/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.stats;

import com.davidsoergel.stats.StatsException;

public class LinearRegression {
    public final double slope;
    public final double intercept;
    public final double R2;
    public final int n;
    public final double slopeStdErr;
    public final double interceptStdErr;
    public final double interceptStdErr2;

    public LinearRegression(double[] x, double[] y) throws StatsException {
        this.n = x.length;
        if (y.length != this.n) {
            throw new StatsException("Cannot compute linear regression between arrays of different lengths");
        }
        double sumx = 0.0;
        double sumy = 0.0;
        double sumx2 = 0.0;
        for (int i = 0; i < this.n; ++i) {
            sumx += x[i];
            sumx2 += x[i] * x[i];
            sumy += y[i];
        }
        double xbar = sumx / (double)this.n;
        double ybar = sumy / (double)this.n;
        double xxbar = 0.0;
        double yybar = 0.0;
        double xybar = 0.0;
        for (int i = 0; i < this.n; ++i) {
            xxbar += (x[i] - xbar) * (x[i] - xbar);
            yybar += (y[i] - ybar) * (y[i] - ybar);
            xybar += (x[i] - xbar) * (y[i] - ybar);
        }
        this.slope = xybar / xxbar;
        this.intercept = ybar - this.slope * xbar;
        if (Double.isNaN(this.slope) || Double.isInfinite(this.slope) || Double.isNaN(this.intercept) || Double.isInfinite(this.intercept)) {
            throw new StatsException("Regression failed with NaN or infinity");
        }
        int df = this.n - 2;
        double rss = 0.0;
        double ssr = 0.0;
        for (int i = 0; i < this.n; ++i) {
            double fit = this.slope * x[i] + this.intercept;
            rss += (fit - y[i]) * (fit - y[i]);
            ssr += (fit - ybar) * (fit - ybar);
        }
        this.R2 = ssr / yybar;
        double svar = rss / (double)df;
        double svar1 = svar / xxbar;
        double svar0 = svar / (double)this.n + xbar * xbar * svar1;
        this.slopeStdErr = Math.sqrt(svar1);
        this.interceptStdErr = Math.sqrt(svar0);
        svar0 = svar * sumx2 / ((double)this.n * xxbar);
        this.interceptStdErr2 = Math.sqrt(svar0);
    }
}

