/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.stats;

import com.davidsoergel.stats.ContinuousDistribution;
import com.davidsoergel.stats.DistributionException;
import com.davidsoergel.stats.MultinomialDistribution;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class MixtureOfDistributions {
    private static final Logger logger = Logger.getLogger(MixtureOfDistributions.class);
    int d;
    MultinomialDistribution mixture = new MultinomialDistribution();
    List<ContinuousDistribution> theComponents = new ArrayList<ContinuousDistribution>();

    public MixtureOfDistributions(int d) {
        this.d = d;
    }

    public void add(ContinuousDistribution c, double proportion) throws DistributionException {
        if (c.getDimensionality() != this.d) {
            throw new DistributionException("Can't add distribution to a mixture of different dimensionality");
        }
        this.theComponents.add(c);
        this.mixture.add(proportion);
    }

    public void normalize() throws DistributionException {
        this.mixture.normalize();
    }

    public double[] sample() throws DistributionException {
        int classid = this.mixture.sample();
        return this.theComponents.get(classid).sample();
    }
}

