/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.stats;

import com.davidsoergel.dsutils.DSArrayUtils;
import com.davidsoergel.dsutils.math.MathUtils;
import com.davidsoergel.dsutils.math.MersenneTwisterFast;
import com.davidsoergel.stats.DiscreteDistribution1D;
import com.davidsoergel.stats.DistributionException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultinomialDistribution
implements DiscreteDistribution1D {
    double[] probs = new double[0];
    private boolean normalized = false;

    public MultinomialDistribution() {
    }

    public MultinomialDistribution(MultinomialDistribution copyFrom) {
        this.probs = (double[])copyFrom.probs.clone();
        this.normalized = copyFrom.normalized;
    }

    public MultinomialDistribution(double[] p) throws DistributionException {
        this.probs = new double[p.length];
        System.arraycopy(p, 0, this.probs, 0, p.length);
        this.normalize();
    }

    public MultinomialDistribution(List<Double> doubles) throws DistributionException {
        this(DSArrayUtils.toPrimitive(doubles.toArray(DSArrayUtils.EMPTY_DOUBLE_OBJECT_ARRAY)));
    }

    public void normalize() throws DistributionException {
        int i;
        double normalizer = 0.0;
        for (i = 0; i < this.probs.length; ++i) {
            if (this.probs[i] < 0.0) {
                throw new DistributionException("Negative probability!");
            }
            normalizer += this.probs[i];
        }
        if (this.probs.length != 0 && normalizer <= 0.0) {
            throw new DistributionException("Can't normalize; no probability weight!");
        }
        i = 0;
        while (i < this.probs.length) {
            int n = i++;
            this.probs[n] = this.probs[n] / normalizer;
        }
        this.normalized = true;
    }

    public MultinomialDistribution(int[] p) throws DistributionException {
        this.probs = DSArrayUtils.castToDouble(p);
        this.normalize();
    }

    @Override
    public int sample() throws DistributionException {
        if (!this.normalized) {
            throw new DistributionException("Multinomial distribution is not normalized.");
        }
        double r = MersenneTwisterFast.random();
        int c = 0;
        while (r >= this.probs[c]) {
            r -= this.probs[c];
            ++c;
        }
        return c;
    }

    public void add(double prob) throws DistributionException {
        if (prob < 0.0) {
            throw new DistributionException("Negative probability!");
        }
        this.probs = DSArrayUtils.grow(this.probs, 1);
        this.probs[this.probs.length - 1] = prob;
        this.normalized = false;
    }

    public boolean isAlreadyNormalized() throws DistributionException {
        if (!this.normalized) {
            double sum = 0.0;
            for (int i = 0; i < this.probs.length; ++i) {
                if (this.probs[i] < 0.0) {
                    throw new DistributionException("Negative probability!");
                }
                sum += this.probs[i];
            }
            if (MathUtils.equalWithinFPError(sum, 1.0)) {
                this.normalized = true;
            }
        }
        return this.normalized;
    }

    public void update(int index, double prob) throws DistributionException {
        if (prob < 0.0) {
            throw new DistributionException("Negative probability!");
        }
        this.probs[index] = prob;
        this.normalized = false;
    }

    public double[] getProbs() {
        return this.probs;
    }
}

