/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.stats;

import com.davidsoergel.dsutils.DSArrayUtils;
import com.davidsoergel.stats.LinearRegression;
import com.davidsoergel.stats.PearsonCorrelation;
import com.davidsoergel.stats.StatsException;
import com.davidsoergel.stats.StatsRuntimeException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class SimpleXYSeries {
    private static final Logger logger = Logger.getLogger(SimpleXYSeries.class);
    private List<XYPoint> points = new ArrayList<XYPoint>();
    protected double xMin = Double.POSITIVE_INFINITY;
    protected double xMax = Double.NEGATIVE_INFINITY;
    private double yMin = Double.POSITIVE_INFINITY;
    private double yMax = Double.NEGATIVE_INFINITY;
    LinearRegression regression = null;
    double correlation;

    public double getXMax() {
        return this.xMax;
    }

    public double getXMin() {
        return this.xMin;
    }

    public double getYMin() {
        return this.yMin;
    }

    public double getYMax() {
        return this.yMax;
    }

    public void addPoint(double x, double y) throws StatsException {
        this.points.add(new XYPoint(x, y));
        this.updateBounds(x, y);
    }

    public void removeNaNAndInfinity() {
        HashSet<XYPoint> pointsToRemove = new HashSet<XYPoint>();
        for (XYPoint point2 : this.points) {
            if (Double.isNaN(point2.x) || Double.isInfinite(point2.x)) {
                pointsToRemove.add(point2);
            }
            if (!Double.isNaN(point2.y) && !Double.isInfinite(point2.y)) continue;
            pointsToRemove.add(point2);
        }
        this.points.removeAll(pointsToRemove);
    }

    private void updateBounds(double x, double y) {
        if (x > this.xMax) {
            this.xMax = x;
        }
        if (y > this.yMax) {
            this.yMax = y;
        }
        if (x < this.xMin) {
            this.xMin = x;
        }
        if (y < this.yMin) {
            this.yMin = y;
        }
    }

    public double getX(int i) {
        return this.points.get((int)i).x;
    }

    public double[] getXArray() {
        double[] result = new double[this.points.size()];
        int i = 0;
        for (XYPoint p : this.points) {
            result[i] = p.x;
            ++i;
        }
        return result;
    }

    public double[] getUniqueXArray() {
        TreeSet<Double> result = new TreeSet<Double>();
        for (XYPoint p : this.points) {
            result.add(p.x);
        }
        return DSArrayUtils.toPrimitive(result.toArray(DSArrayUtils.EMPTY_DOUBLE_OBJECT_ARRAY));
    }

    public double getY(int i) {
        return this.points.get((int)i).y;
    }

    public double[] getYArray() {
        double[] result = new double[this.points.size()];
        int i = 0;
        for (XYPoint p : this.points) {
            result[i] = p.y;
            ++i;
        }
        return result;
    }

    public double[] getYArray(double xmin, double xmax) {
        ArrayList<Double> result = new ArrayList<Double>();
        for (XYPoint p : this.points) {
            if (!(p.x >= xmin) || !(p.x <= xmax)) continue;
            result.add(p.y);
        }
        return DSArrayUtils.toPrimitive(result.toArray(new Double[0]), 0.0);
    }

    public int size() {
        return this.points.size();
    }

    public SimpleXYSeries getYSmoothedCopy(double smoothFactor) throws StatsException {
        if (smoothFactor == 0.0) {
            return this;
        }
        SimpleXYSeries result = new SimpleXYSeries();
        for (XYPoint p : this.points) {
            result.addPoint(p.x, DSArrayUtils.mean(this.getYArray(p.x - smoothFactor, p.x + smoothFactor)));
        }
        return result;
    }

    public static SimpleXYSeries yVsY(SimpleXYSeries theSeries1, SimpleXYSeries theSeries2) throws StatsException {
        SimpleXYSeries result = new SimpleXYSeries();
        int size = theSeries1.size();
        if (theSeries2.size() != size) {
            throw new StatsRuntimeException("Can't make Y vs. Y plot when # of points differ");
        }
        for (int i = 0; i < size; ++i) {
            result.addPoint(theSeries1.getY(i), theSeries2.getY(i));
        }
        return result;
    }

    public double pearsonCorrelation() throws StatsException {
        if (this.regression == null) {
            this.computeRegression();
        }
        return this.correlation;
    }

    public double R2() throws StatsException {
        if (this.regression == null) {
            this.computeRegression();
        }
        logger.debug("Correlations: " + this.regression.R2 + ", " + this.correlation);
        return this.regression.R2;
    }

    public double regressionM() throws StatsException {
        if (this.regression == null) {
            this.computeRegression();
        }
        return this.regression.slope;
    }

    public double regressionB() throws StatsException {
        if (this.regression == null) {
            this.computeRegression();
        }
        return this.regression.intercept;
    }

    private void computeRegression() throws StatsException {
        double[] xs = new double[this.size()];
        double[] ys = new double[this.size()];
        int i = 0;
        for (XYPoint point2 : this.points) {
            xs[i] = point2.x;
            ys[i] = point2.y;
            ++i;
        }
        this.regression = new LinearRegression(xs, ys);
        this.correlation = PearsonCorrelation.computeCorrelationCoefficient(xs, ys);
    }

    protected static class XYPoint
    implements Comparable {
        public double x;
        public double y;

        public XYPoint(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public int compareTo(Object o) {
            return Double.compare(this.x, ((XYPoint)o).x);
        }
    }
}

