/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.stats;

import com.davidsoergel.stats.Histogram1D;
import com.davidsoergel.stats.StatsException;

public abstract class VariableWidthHistogram1D
extends Histogram1D {
    double[] lowerBoundaries;

    public VariableWidthHistogram1D(double from, double to, int bins) {
        super(from, to, bins);
        this.lowerBoundaries = new double[bins + 1];
        this.lowerBoundaries[0] = from;
        this.lowerBoundaries[bins] = to;
    }

    public int findBinNumber(double x) throws StatsException {
        if (x < this.from || x > this.to) {
            throw new StatsException("Requested number  " + x + " not in histogram range " + this.from + " - " + this.to);
        }
        for (int i = 0; i < this.bins; ++i) {
            if (!(x >= this.lowerBoundaries[i]) || !(x < this.lowerBoundaries[i + 1])) continue;
            return i;
        }
        throw new Error("Impossible");
    }

    public double bottomOfBin(int bin) throws StatsException {
        if (bin < 0 || bin >= this.bins) {
            throw new StatsException("Requested bin " + bin + " not in histogram range 0 - " + (this.bins - 1));
        }
        return this.lowerBoundaries[bin];
    }

    public double getBoundary(int i) {
        return this.lowerBoundaries[i];
    }

    public double topOfBin(int bin) throws StatsException {
        if (bin < 0 || bin >= this.bins) {
            throw new StatsException("Requested bin " + bin + " not in histogram range 0 - " + this.bins);
        }
        return this.lowerBoundaries[bin + 1];
    }
}

