/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.trees;

import com.davidsoergel.trees.DepthFirstTreeIterator;
import com.davidsoergel.trees.DepthFirstTreeIteratorImpl;
import com.davidsoergel.trees.HierarchyNode;
import com.davidsoergel.trees.NoSuchNodeException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHierarchyNode<KV, H extends HierarchyNode<KV, H>>
implements HierarchyNode<KV, H> {
    protected H parent;
    protected KV payload;

    protected AbstractHierarchyNode(KV payload) {
        this.payload = payload;
    }

    protected AbstractHierarchyNode() {
    }

    @Override
    public KV getPayload() {
        return this.payload;
    }

    @Override
    public void setPayload(KV payload) {
        this.payload = payload;
    }

    @Override
    public H getParent() {
        return this.parent;
    }

    @Override
    public void setParent(H parent) {
        if (this.parent == parent) {
            return;
        }
        if (this.parent != null) {
            this.parent.unregisterChild((AbstractHierarchyNode)this);
        }
        this.parent = parent;
        if (this.parent != null) {
            this.parent.registerChild((AbstractHierarchyNode)this);
        }
    }

    @Override
    public abstract Collection<? extends H> getChildren();

    @Override
    @NotNull
    public H getChildWithPayload(KV payload) throws NoSuchNodeException {
        for (HierarchyNode child : this.getChildren()) {
            Object cp = child.getPayload();
            if ((cp != null || payload != null) && !cp.equals(payload)) continue;
            return (H)child;
        }
        throw new NoSuchNodeException();
    }

    @Override
    public boolean isLeaf() {
        Collection<H> children = this.getChildren();
        return children == null || children.isEmpty();
    }

    @Override
    public List<HierarchyNode<KV, H>> getAncestorPath() {
        return this.getAncestorPath(true);
    }

    @Override
    public List<HierarchyNode<KV, H>> getAncestorPath(boolean includeSelf) {
        AbstractHierarchyNode<KV, H> trav;
        LinkedList<HierarchyNode<KV, H>> result = new LinkedList<HierarchyNode<KV, H>>();
        AbstractHierarchyNode<KV, H> abstractHierarchyNode = trav = includeSelf ? this : this.getParent();
        while (trav != null) {
            result.add(0, trav);
            trav = trav.getParent();
        }
        return result;
    }

    @Override
    public List<KV> getAncestorPathPayloads() {
        LinkedList result = new LinkedList();
        for (AbstractHierarchyNode<KV, H> trav = this; trav != null; trav = trav.getParent()) {
            result.add(0, trav.getPayload());
        }
        return result;
    }

    @Override
    public Iterator<H> iterator() {
        return new DepthFirstTreeIteratorImpl(this);
    }

    @Override
    public DepthFirstTreeIterator<KV, H> depthFirstIterator() {
        return new DepthFirstTreeIteratorImpl(this);
    }

    @Override
    public HierarchyNode<KV, H> getSelfNode() {
        return this;
    }

    @Override
    public int countDescendantsIncludingThis() {
        int result = 1;
        for (HierarchyNode c : this.getChildren()) {
            result += c.countDescendantsIncludingThis();
        }
        return result;
    }
}

