/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.trees;

import com.davidsoergel.dsutils.collections.ConcurrentHashWeightedSet;
import com.davidsoergel.dsutils.collections.DSCollectionUtils;
import com.davidsoergel.dsutils.collections.MutableWeightedSet;
import com.davidsoergel.stats.ContinuousDistribution1D;
import com.davidsoergel.trees.BasicPhylogenyNode;
import com.davidsoergel.trees.BasicRootedPhylogeny;
import com.davidsoergel.trees.NoSuchNodeException;
import com.davidsoergel.trees.NodeNamer;
import com.davidsoergel.trees.PhylogenyNode;
import com.davidsoergel.trees.RequireExistingNodeNamer;
import com.davidsoergel.trees.RootedPhylogeny;
import com.davidsoergel.trees.TreeException;
import com.davidsoergel.trees.TreeRuntimeException;
import com.google.common.collect.Multiset;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.lang.NotImplementedException;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRootedPhylogeny<T extends Serializable>
implements RootedPhylogeny<T> {
    private static final Logger logger = Logger.getLogger(AbstractRootedPhylogeny.class);
    protected transient RootedPhylogeny<T> basePhylogeny = null;
    private String name;
    private static final int MAX_SEARCH_ITERATIONS = 1000;

    @Override
    @NotNull
    public T commonAncestor(Collection<T> knownMergeIds) throws NoSuchNodeException {
        return this.commonAncestor((T)knownMergeIds, (T)1.0);
    }

    @Override
    public RootedPhylogeny<T> asRootedPhylogeny() {
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    @NotNull
    public T commonAncestor(Collection<T> knownMergeIds, double proportion) throws NoSuchNodeException {
        Set<List<Object>> theDisposableAncestorLists = new HashSet();
        for (Serializable id : knownMergeIds) {
            try {
                PhylogenyNode<Serializable> node = this.getNode(id);
                theDisposableAncestorLists.add(new ArrayList<PhylogenyNode<Serializable>>(node.getAncestorPath()));
            }
            catch (NoSuchNodeException e) {
                logger.debug("Node not found with id " + id + " when looking for common ancestor; ignoring");
            }
        }
        int numberThatMustAgree = (int)Math.ceil((double)theDisposableAncestorLists.size() * proportion);
        PhylogenyNode commonAncestor = null;
        try {
            while (true) {
                commonAncestor = (PhylogenyNode)DSCollectionUtils.getDominantFirstElement(theDisposableAncestorLists, numberThatMustAgree);
                theDisposableAncestorLists = DSCollectionUtils.filterByAndRemoveFirstElement(theDisposableAncestorLists, commonAncestor);
            }
        }
        catch (NoSuchElementException e) {
            if (commonAncestor == null) {
                throw new NoSuchNodeException("Nodes have no common ancestor");
            }
            return (T)((Serializable)commonAncestor.getPayload());
        }
    }

    @Override
    @NotNull
    public T commonAncestor(T nameA, T nameB) throws NoSuchNodeException {
        PhylogenyNode<T> a = this.getNode(nameA);
        PhylogenyNode<T> b = this.getNode(nameB);
        return (T)((Serializable)this.commonAncestor(a, b).getPayload());
    }

    @Override
    @NotNull
    public PhylogenyNode<T> commonAncestor(@NotNull PhylogenyNode<T> a, @NotNull PhylogenyNode<T> b) throws NoSuchNodeException {
        LinkedList<PhylogenyNode<T>> ancestorsA = new LinkedList<PhylogenyNode<T>>(a.getAncestorPath());
        LinkedList<PhylogenyNode<T>> ancestorsB = new LinkedList<PhylogenyNode<T>>(b.getAncestorPath());
        PhylogenyNode commonAncestor = null;
        while (ancestorsA.size() > 0 && ancestorsB.size() > 0 && ((PhylogenyNode)ancestorsA.get(0)).equals(ancestorsB.get(0))) {
            commonAncestor = (PhylogenyNode)ancestorsA.remove(0);
            ancestorsB.remove(0);
        }
        if (commonAncestor == null) {
            throw new NoSuchNodeException("Nodes have no common ancestor");
        }
        return commonAncestor;
    }

    @Override
    public boolean isDescendant(T ancestor, T descendant) {
        try {
            List<T> ancestorPath = this.getAncestorPathIds(descendant);
            if (ancestorPath == null) {
                return false;
            }
            return ancestorPath.contains(ancestor);
        }
        catch (NoSuchNodeException e) {
            return false;
        }
    }

    @Override
    public Set<T> selectAncestors(Collection<T> labels, T id) {
        try {
            List<T> ancestorPath = this.getAncestorPathIds(id);
            return DSCollectionUtils.intersectionSet(ancestorPath, labels);
        }
        catch (NoSuchNodeException e) {
            return new HashSet();
        }
    }

    @Override
    public boolean isDescendant(PhylogenyNode<T> ancestor, PhylogenyNode<T> descendant) {
        try {
            return ancestor.equals(this.commonAncestor(ancestor, descendant));
        }
        catch (NoSuchNodeException e) {
            return false;
        }
    }

    @Override
    @NotNull
    public BasicRootedPhylogeny<T> extractTreeWithLeafIDs(Set<T> ids, boolean ignoreAbsentNodes, boolean includeInternalBranches) throws NoSuchNodeException {
        return this.extractTreeWithLeafIDs(ids, ignoreAbsentNodes, includeInternalBranches, MutualExclusionResolutionMode.EXCEPTION);
    }

    @Override
    @NotNull
    public BasicRootedPhylogeny<T> extractTreeWithLeafIDs(Set<T> ids, boolean ignoreAbsentNodes, boolean includeInternalBranches, MutualExclusionResolutionMode mode) throws NoSuchNodeException {
        Set<List<PhylogenyNode<T>>> theDisposableLeafPaths = this.idsToDisposableBasicLeafPaths(ids, ignoreAbsentNodes);
        if (theDisposableLeafPaths.isEmpty()) {
            throw new NoSuchNodeException("No leaves found for ids: " + ids);
        }
        BasicRootedPhylogeny<T> result = this.extractTreeWithLeafPaths(theDisposableLeafPaths, includeInternalBranches, mode);
        Set<T> gotLeaves = result.getLeafValues();
        Set<T> gotNodes = result.getNodeValues();
        assert (ids.containsAll(gotLeaves));
        if (!ignoreAbsentNodes) assert (gotNodes.containsAll(ids));
        return result;
    }

    protected Set<List<? extends PhylogenyNode<T>>> idsToDisposableBasicLeafPaths(Set<T> ids, boolean ignoreAbsentNodes) throws NoSuchNodeException {
        HashSet<List<PhylogenyNode<T>>> theLeafPaths = new HashSet<List<PhylogenyNode<T>>>();
        for (Serializable id : ids) {
            try {
                ArrayList<BasicPhylogenyNode<Serializable>> safecopy = new ArrayList<BasicPhylogenyNode<Serializable>>(this.getAncestorPathAsBasic(id));
                theLeafPaths.add(safecopy);
            }
            catch (NoSuchNodeException e) {
                if (ignoreAbsentNodes) continue;
                throw new NoSuchNodeException("Can't extract tree; requested node " + id + " not found");
            }
        }
        return theLeafPaths;
    }

    @NotNull
    public BasicRootedPhylogeny<T> extractTreeWithLeaves(Collection<? extends PhylogenyNode<T>> leaves, boolean includeInternalBranches, MutualExclusionResolutionMode mode) {
        HashSet<List<PhylogenyNode<T>>> theDisposableAncestorLists = new HashSet<List<PhylogenyNode<T>>>(leaves.size());
        for (PhylogenyNode<T> leaf : leaves) {
            theDisposableAncestorLists.add(new ArrayList<PhylogenyNode<T>>(leaf.getAncestorPath()));
        }
        return this.extractTreeWithLeafPaths(theDisposableAncestorLists, includeInternalBranches, mode);
    }

    @NotNull
    public BasicRootedPhylogeny<T> extractTreeWithLeafPaths(Set<List<? extends PhylogenyNode<T>>> theDisposableAncestorLists, boolean includeInternalBranches, MutualExclusionResolutionMode mode) {
        BasicPhylogenyNode<T> commonAncestor = null;
        try {
            commonAncestor = this.extractSubtreeWithLeafPaths(theDisposableAncestorLists, includeInternalBranches, mode);
        }
        catch (NoSuchNodeException e) {
            logger.error("Error", e);
            throw new TreeRuntimeException(e);
        }
        BasicRootedPhylogeny<Serializable> newTree = new BasicRootedPhylogeny<Serializable>((Serializable)this.getPayload());
        if (!commonAncestor.getPayload().equals(this.getPayload())) {
            commonAncestor.setParent(newTree.getRoot());
        } else {
            newTree.setRoot(commonAncestor);
        }
        newTree.assignUniqueIds(new RequireExistingNodeNamer(true));
        newTree.setBasePhylogeny(this);
        return newTree;
    }

    @Override
    public List<T> getAncestorPathIds(T id) throws NoSuchNodeException {
        return this.getNode(id).getAncestorPathPayloads();
    }

    public List<? extends PhylogenyNode<T>> getAncestorPath(T id) throws NoSuchNodeException {
        return this.getNode(id).getAncestorPath();
    }

    @Override
    @NotNull
    public List<BasicPhylogenyNode<T>> getAncestorPathAsBasic(T id) throws NoSuchNodeException {
        List<PhylogenyNode<T>> orig = this.getNode(id).getAncestorPath();
        ArrayList<BasicPhylogenyNode<T>> result = new ArrayList<BasicPhylogenyNode<T>>();
        BasicPhylogenyNode<T> parent = null;
        for (PhylogenyNode<T> origNode : orig) {
            BasicPhylogenyNode<T> convertedNode = origNode instanceof BasicPhylogenyNode ? (BasicPhylogenyNode<T>)origNode : new BasicPhylogenyNode<T>(parent, origNode);
            result.add(convertedNode);
            parent = convertedNode;
        }
        return Collections.unmodifiableList(result);
    }

    @NotNull
    protected BasicPhylogenyNode<T> extractSubtreeWithLeafPaths(Set<List<? extends PhylogenyNode<T>>> theDisposableAncestorLists, boolean includeInternalBranches, MutualExclusionResolutionMode mode) throws NoSuchNodeException {
        BasicPhylogenyNode<T> result = includeInternalBranches ? this.extractSubtreeWithLeafPathsIncludingInternal(theDisposableAncestorLists, mode) : this.extractSubtreeWithLeafPathsExcludingInternal(theDisposableAncestorLists, mode);
        return result;
    }

    private BasicPhylogenyNode<T> extractSubtreeWithLeafPathsExcludingInternal(Set<List<? extends PhylogenyNode<T>>> theDisposableAncestorLists, MutualExclusionResolutionMode mode) throws NoSuchNodeException {
        double accumulatedLength = 0.0;
        PhylogenyNode commonAncestor = null;
        BasicPhylogenyNode<Serializable> bottomOfChain = null;
        while (true) {
            if (DSCollectionUtils.allFirstElementsEqual(theDisposableAncestorLists)) {
                commonAncestor = (PhylogenyNode)DSCollectionUtils.removeAllFirstElements(theDisposableAncestorLists);
                Double d = commonAncestor.getLength();
                if (d == null) continue;
                accumulatedLength += d.doubleValue();
                continue;
            }
            if (this.resolveMutualExclusion(theDisposableAncestorLists, mode)) break;
        }
        if (commonAncestor == null) {
            throw new NoSuchNodeException("Provided ancestor lists do not have a common root");
        }
        BasicPhylogenyNode<Serializable> node = new BasicPhylogenyNode<Serializable>();
        node.setLength(accumulatedLength);
        node.setPayload((Serializable)commonAncestor.getPayload());
        node.setWeight(commonAncestor.getWeight());
        bottomOfChain = node;
        Collection<Set<List<PhylogenyNode<T>>>> childAncestorLists = this.separateFirstAncestorSets(theDisposableAncestorLists);
        assert (childAncestorLists.size() != 1);
        for (Set<List<? extends PhylogenyNode<T>>> set : childAncestorLists) {
            BasicPhylogenyNode child = this.extractSubtreeWithLeafPathsExcludingInternal(set, mode);
            child.setParent(bottomOfChain);
        }
        return bottomOfChain.findRoot();
    }

    private BasicPhylogenyNode<T> extractSubtreeWithLeafPathsIncludingInternal(Set<List<? extends PhylogenyNode<T>>> theDisposableAncestorLists, MutualExclusionResolutionMode mode) throws NoSuchNodeException {
        PhylogenyNode commonAncestor = null;
        BasicPhylogenyNode<Serializable> bottomOfChain = null;
        while (DSCollectionUtils.allFirstElementsEqual(theDisposableAncestorLists)) {
            commonAncestor = (PhylogenyNode)DSCollectionUtils.removeAllFirstElements(theDisposableAncestorLists);
            BasicPhylogenyNode<Serializable> node = new BasicPhylogenyNode<Serializable>();
            node.setLength(commonAncestor.getLength());
            node.setPayload((Serializable)commonAncestor.getPayload());
            if (bottomOfChain != null) {
                bottomOfChain.setWeight(null);
            }
            try {
                node.setWeight(commonAncestor.getWeight());
            }
            catch (NotImplementedException e) {
                node.setWeight(1.0);
            }
            node.setParent((PhylogenyNode<Serializable>)bottomOfChain);
            bottomOfChain = node;
            this.resolveMutualExclusion(theDisposableAncestorLists, mode);
        }
        if (commonAncestor == null) {
            throw new NoSuchNodeException("Provided ancestor lists do not have a common root");
        }
        Collection<Set<List<PhylogenyNode<T>>>> childAncestorLists = this.separateFirstAncestorSets(theDisposableAncestorLists);
        for (Set<List<? extends PhylogenyNode<T>>> set : childAncestorLists) {
            BasicPhylogenyNode child = this.extractSubtreeWithLeafPathsIncludingInternal(set, mode);
            child.setParent(bottomOfChain);
        }
        return bottomOfChain.findRoot();
    }

    private boolean resolveMutualExclusion(Set<List<? extends PhylogenyNode<T>>> theDisposableAncestorLists, MutualExclusionResolutionMode mode) {
        if (theDisposableAncestorLists.size() == 1) {
            return true;
        }
        assert (theDisposableAncestorLists.size() > 1);
        Iterator<List<PhylogenyNode<T>>> iterator = theDisposableAncestorLists.iterator();
        while (iterator.hasNext()) {
            List<PhylogenyNode<T>> ancestorList = iterator.next();
            if (!ancestorList.isEmpty()) continue;
            if (mode == MutualExclusionResolutionMode.LEAF) {
                iterator.remove();
                return false;
            }
            if (mode == MutualExclusionResolutionMode.ANCESTOR) {
                theDisposableAncestorLists.clear();
                theDisposableAncestorLists.add(new ArrayList());
                return true;
            }
            if (mode == MutualExclusionResolutionMode.BOTH) {
                iterator.remove();
                return true;
            }
            throw new TreeRuntimeException("Requested extraction of an internal node as a leaf");
        }
        return true;
    }

    private Collection<Set<List<? extends PhylogenyNode<T>>>> separateFirstAncestorSets(Set<List<? extends PhylogenyNode<T>>> theAncestorLists) {
        HashMap<PhylogenyNode<T>, HashSet<List<PhylogenyNode<T>>>> theSeparatedSets = new HashMap<PhylogenyNode<T>, HashSet<List<PhylogenyNode<T>>>>();
        for (List<PhylogenyNode<T>> theAncestorList : theAncestorLists) {
            if (theAncestorList.isEmpty()) continue;
            PhylogenyNode<T> commonAncestor = theAncestorList.get(0);
            HashSet<List<PhylogenyNode<T>>> theChildList = (HashSet<List<PhylogenyNode<T>>>)theSeparatedSets.get(commonAncestor);
            if (theChildList == null) {
                theChildList = new HashSet<List<PhylogenyNode<T>>>();
                theSeparatedSets.put(commonAncestor, theChildList);
            }
            theChildList.add(theAncestorList);
        }
        return theSeparatedSets.values();
    }

    @Override
    public double distanceBetween(T nameA, T nameB) throws NoSuchNodeException {
        PhylogenyNode<T> a = this.getNode(nameA);
        PhylogenyNode<T> b = this.getNode(nameB);
        return this.distanceBetween(a, b);
    }

    @Override
    public double distanceBetween(PhylogenyNode<T> a, PhylogenyNode<T> b) throws NoSuchNodeException {
        ArrayList<PhylogenyNode<T>> ancestorsA = new ArrayList<PhylogenyNode<T>>(a.getAncestorPath());
        ArrayList<PhylogenyNode<T>> ancestorsB = new ArrayList<PhylogenyNode<T>>(b.getAncestorPath());
        int commonAncestors = 0;
        while (!ancestorsA.isEmpty() && !ancestorsB.isEmpty() && ((PhylogenyNode)ancestorsA.get(0)).equals(ancestorsB.get(0))) {
            ancestorsA.remove(0);
            ancestorsB.remove(0);
            ++commonAncestors;
        }
        if (commonAncestors == 0) {
            throw new NoSuchNodeException("Can't compute distance between nodes with no common ancestor");
        }
        double dist = 0.0;
        for (PhylogenyNode phylogenyNode : ancestorsA) {
            dist += phylogenyNode.getLength().doubleValue();
        }
        for (PhylogenyNode phylogenyNode : ancestorsB) {
            dist += phylogenyNode.getLength().doubleValue();
        }
        return dist;
    }

    @Override
    public double getTotalBranchLength() {
        double result = 0.0;
        for (PhylogenyNode node : this.getUniqueIdToNodeMap().values()) {
            if (node.getLength() == null) continue;
            result += node.getLength().doubleValue();
        }
        return result;
    }

    @Override
    public void setAllBranchLengthsTo(Double d) {
        for (PhylogenyNode node : this.getUniqueIdToNodeMap().values()) {
            node.setLength(d);
        }
    }

    @Override
    public void randomizeLeafWeights(ContinuousDistribution1D speciesAbundanceDistribution) {
        for (PhylogenyNode leaf : this.getLeaves()) {
            leaf.setWeight(speciesAbundanceDistribution.sample());
        }
        try {
            this.normalizeWeights();
        }
        catch (TreeException e) {
            logger.error("Error", e);
            throw new Error("Impossible");
        }
    }

    @Override
    public void uniformizeLeafWeights() {
        for (PhylogenyNode leaf : this.getLeaves()) {
            leaf.setWeight(1.0);
        }
        try {
            this.normalizeWeights();
        }
        catch (TreeException e) {
            logger.error("Error", e);
            throw new Error("Impossible");
        }
    }

    @Override
    public Map<T, Double> distributeInternalWeightsToLeaves(Map<T, Double> taxIdToWeightMap) throws NoSuchNodeException {
        ConcurrentHashWeightedSet result = new ConcurrentHashWeightedSet();
        for (Map.Entry<T, Double> entry : taxIdToWeightMap.entrySet()) {
            Serializable id = (Serializable)entry.getKey();
            Double weight = entry.getValue();
            try {
                PhylogenyNode<Serializable> n = this.getNode(id);
                this.distributeWeight(n, weight, result);
            }
            catch (NoSuchNodeException e) {
                logger.warn("Requested member weight dropped: " + id + " " + weight);
            }
        }
        return result.getItemNormalizedMap();
    }

    private void distributeWeight(PhylogenyNode<T> n, Double weight, MutableWeightedSet<T> result) throws NoSuchNodeException {
        if (n.isLeaf()) {
            result.add(n.getPayload(), weight, 1);
        } else {
            List<PhylogenyNode<T>> children = n.getChildren();
            double childWeight = weight / (double)children.size();
            for (PhylogenyNode<T> child : children) {
                this.distributeWeight(child, childWeight, result);
            }
        }
    }

    @Override
    public void setLeafWeights(Multiset<T> leafWeights) throws TreeException {
        for (PhylogenyNode leaf : this.getLeaves()) {
            int value = leafWeights.count(leaf.getPayload());
            leaf.setWeight(new Double(value));
        }
        this.normalizeWeights();
    }

    @Override
    public void setLeafWeights(Map<T, Double> leafWeights) throws TreeException {
        for (PhylogenyNode leaf : this.getLeaves()) {
            Double value = leafWeights.get(leaf.getPayload());
            if (value == null) {
                throw new TreeException("No leaf weight provided for " + leaf);
            }
            leaf.setWeight(value);
        }
        this.normalizeWeights();
    }

    @Override
    public Map<T, Double> getLeafWeights() {
        HashMap result = new HashMap();
        for (PhylogenyNode leaf : this.getLeaves()) {
            result.put(leaf.getPayload(), leaf.getWeight());
        }
        return result;
    }

    @Override
    public Map<T, Double> getNodeWeights() {
        HashMap result = new HashMap();
        for (PhylogenyNode node : this) {
            result.put(node.getPayload(), node.getWeight());
        }
        return result;
    }

    @Override
    public void normalizeWeights() throws TreeException {
        double total = 0.0;
        for (PhylogenyNode leaf : this.getLeaves()) {
            Double w = leaf.getWeight();
            if (w == null) {
                throw new TreeException("Can't normalize when a leaf weight is null");
            }
            total += w.doubleValue();
        }
        for (PhylogenyNode leaf : this.getLeaves()) {
            leaf.setWeight(leaf.getWeight() / total);
        }
    }

    @Override
    public RootedPhylogeny<T> getBasePhylogeny() {
        return this.basePhylogeny;
    }

    @Override
    public RootedPhylogeny<T> getBasePhylogenyRecursive() {
        if (this.basePhylogeny == null) {
            return this;
        }
        return this.basePhylogeny.getBasePhylogenyRecursive();
    }

    public void setBasePhylogeny(RootedPhylogeny<T> basePhylogeny) {
        this.basePhylogeny = basePhylogeny;
    }

    @Override
    public BasicRootedPhylogeny<T> extractIntersectionTree(Collection<T> leafIdsA, Collection<T> leafIdsB, NodeNamer<T> namer) throws NoSuchNodeException, TreeException {
        HashSet<PhylogenyNode<Serializable>> allTreeNodesA = new HashSet<PhylogenyNode<Serializable>>();
        for (Serializable id : leafIdsA) {
            allTreeNodesA.addAll(this.getNode(id).getAncestorPath());
        }
        HashSet<PhylogenyNode<Serializable>> allTreeNodesB = new HashSet<PhylogenyNode<Serializable>>();
        for (Serializable id : leafIdsB) {
            allTreeNodesB.addAll(this.getNode(id).getAncestorPath());
        }
        allTreeNodesA.retainAll(allTreeNodesB);
        for (PhylogenyNode node : new HashSet(allTreeNodesA)) {
            allTreeNodesA.remove(node.getParent());
        }
        return this.extractTreeWithLeaves(allTreeNodesA, false, MutualExclusionResolutionMode.EXCEPTION);
    }

    @Override
    public BasicRootedPhylogeny<T> mixWith(RootedPhylogeny<T> otherTree, double mixingProportion) throws TreeException {
        if (mixingProportion < 0.0 || mixingProportion > 1.0) {
            throw new TreeException("Mixing proportion must be between 0 and 1");
        }
        if (this.basePhylogeny == null || this.basePhylogeny != otherTree.getBasePhylogeny()) {
            throw new TreeException("Phylogeny mixtures can be computed only between trees extracted from the same underlying tree");
        }
        try {
            HashSet<T> unionLeaves = new HashSet<T>();
            unionLeaves.addAll(this.getLeafValues());
            unionLeaves.addAll(otherTree.getLeafValues());
            BasicRootedPhylogeny unionTree = this.basePhylogeny.extractTreeWithLeafIDs(unionLeaves, false, false, MutualExclusionResolutionMode.EXCEPTION);
            for (PhylogenyNode node : this.getLeaves()) {
                ((BasicPhylogenyNode)unionTree.getNode((Serializable)node.getPayload())).setWeight(node.getWeight() * mixingProportion);
            }
            for (PhylogenyNode node : otherTree.getLeaves()) {
                ((BasicPhylogenyNode)unionTree.getNode((Serializable)node.getPayload())).incrementWeightBy(node.getWeight() * (1.0 - mixingProportion));
            }
            unionTree.normalizeWeights();
            return unionTree;
        }
        catch (NoSuchNodeException e) {
            logger.error("Error", e);
            throw new TreeRuntimeException(e);
        }
    }

    @Override
    public void smoothWeightsFrom(RootedPhylogeny<T> otherTree, double smoothingFactor) throws TreeException {
        try {
            for (PhylogenyNode leaf : this.getLeaves()) {
                Serializable leafId = (Serializable)leaf.getPayload();
                PhylogenyNode<Serializable> otherLeaf = null;
                PhylogenyNode<Serializable> node = this.getNode(leafId);
                try {
                    otherLeaf = otherTree.getNode(leafId);
                    node.setWeight(otherLeaf.getWeight() + smoothingFactor);
                }
                catch (NoSuchNodeException e) {
                    node.setWeight(smoothingFactor);
                }
            }
        }
        catch (NoSuchNodeException e) {
            logger.error("Error", e);
            throw new TreeRuntimeException(e);
        }
        this.normalizeWeights();
    }

    @Override
    public abstract RootedPhylogeny<T> clone();

    public String toString() {
        StringBuffer sb = new StringBuffer("\n");
        this.appendSubtree(sb, "");
        return sb.toString();
    }

    @Override
    @NotNull
    public T getShallowestLeaf() {
        try {
            Serializable shallowestId = null;
            double shallowestDepth = Double.POSITIVE_INFINITY;
            for (PhylogenyNode n : this.getLeaves()) {
                double depth = this.distanceBetween(this.getRoot(), n);
                Serializable nId = (Serializable)n.getPayload();
                if (!(depth < shallowestDepth) && (depth != shallowestDepth || nId.hashCode() >= shallowestId.hashCode())) continue;
                shallowestDepth = depth;
                shallowestId = nId;
            }
            return (T)shallowestId;
        }
        catch (NoSuchNodeException e) {
            throw new Error("Impossible");
        }
    }

    @Override
    public PhylogenyNode<T> getFirstBranchingNode() {
        PhylogenyNode r = this.getRoot();
        while (r.getChildren().size() == 1) {
            r = r.getChildren().iterator().next();
        }
        return r;
    }

    @Override
    public PhylogenyNode<T> getRandomLeafBelow() {
        return this.getRoot().getRandomLeafBelow();
    }

    @Override
    public T getLeafAtApproximateDistance(T aId, double minDesiredTreeDistance, double maxDesiredTreeDistance) throws NoSuchNodeException {
        PhylogenyNode<T> queryNode;
        PhylogenyNode<T> p;
        double distanceToSubtreeRoot = 0.0;
        PhylogenyNode root = this.getRoot();
        for (p = queryNode = this.getNode(aId); distanceToSubtreeRoot < maxDesiredTreeDistance && p != root; distanceToSubtreeRoot += p.getLength().doubleValue(), p = p.getParent()) {
        }
        for (int i = 0; i < 1000; ++i) {
            PhylogenyNode<T> candidate = p.getRandomLeafBelow();
            double candidateDistance = this.distanceBetween(queryNode, candidate);
            if (!(candidateDistance >= minDesiredTreeDistance) || !(candidateDistance <= maxDesiredTreeDistance)) continue;
            return (T)((Serializable)candidate.getPayload());
        }
        throw new NoSuchNodeException("Could not find a node in the requested distance range (" + minDesiredTreeDistance + " - " + maxDesiredTreeDistance + " from " + aId + ") after " + 1000 + " attempts");
    }

    @Override
    public int countDescendantsIncludingThis() {
        int result = 1;
        for (PhylogenyNode c : this.getChildren()) {
            result += c.countDescendantsIncludingThis();
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MutualExclusionResolutionMode {
        LEAF,
        ANCESTOR,
        BOTH,
        EXCEPTION;

    }
}

