/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.trees;

import com.davidsoergel.dsutils.collections.DSCollectionUtils;
import com.davidsoergel.trees.BasicRootedPhylogeny;
import com.davidsoergel.trees.DepthFirstTreeIterator;
import com.davidsoergel.trees.DepthFirstTreeIteratorImpl;
import com.davidsoergel.trees.NoSuchNodeException;
import com.davidsoergel.trees.NodeNamer;
import com.davidsoergel.trees.PhylogenyNode;
import com.davidsoergel.trees.SerializablePhylogenyNode;
import com.davidsoergel.trees.TreeException;
import com.davidsoergel.trees.TreeRuntimeException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicPhylogenyNode<T extends Serializable>
implements SerializablePhylogenyNode<T> {
    private static final long serialVersionUID = 20090720L;
    private static final Logger logger = Logger.getLogger(BasicPhylogenyNode.class);
    protected transient BasicPhylogenyNode<T> parent;
    protected List<BasicPhylogenyNode<T>> children = new ArrayList<BasicPhylogenyNode<T>>();
    protected T value;
    protected Double length;
    protected Double weight;
    protected Double bootstrap;
    private String name;
    private List<PhylogenyNode<T>> ancestorPath = null;
    private List<T> ancestorPathIds = null;
    Double greatestBranchLengthDepth = null;
    Integer greatestNodeDepth = null;
    Double secondGreatestDepth = null;
    Double largestLengthSpan = null;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int countDescendantsIncludingThis() {
        int result = 1;
        for (BasicPhylogenyNode c : this.getChildren()) {
            result += c.countDescendantsIncludingThis();
        }
        return result;
    }

    @Override
    public void toNewick(StringBuffer sb, String prefix, String tab, int minClusterSize, double minLabelProb) {
        if (prefix != null) {
            sb.append(prefix);
        }
        if (!this.children.isEmpty()) {
            String childPrefix = prefix == null ? null : prefix + tab;
            sb.append("(");
            Iterator<BasicPhylogenyNode<T>> i = this.children.iterator();
            while (i.hasNext()) {
                i.next().toNewick(sb, childPrefix, tab, minClusterSize, minLabelProb);
                if (!i.hasNext()) continue;
                sb.append(",");
            }
            if (prefix != null) {
                sb.append(prefix);
            }
            sb.append(")");
            if (prefix != null) {
                sb.append(prefix);
            }
        }
        String n = this.value.toString();
        n = n.replaceAll(" ", "_");
        sb.append(n);
        if (this.length != null) {
            sb.append(String.format(":%.5f", this.length));
        }
        if (this.bootstrap != null) {
            sb.append("[").append(this.bootstrap).append("]");
        }
    }

    public BasicPhylogenyNode() {
    }

    public BasicPhylogenyNode(T value) {
        this();
        this.setPayload(value);
    }

    public BasicPhylogenyNode(BasicPhylogenyNode<T> parent) {
        this();
        this.setParent(parent);
    }

    public BasicPhylogenyNode(BasicPhylogenyNode<T> parent, double length) {
        this(parent);
        this.length = length;
    }

    public BasicPhylogenyNode(BasicPhylogenyNode<T> parent, T value, double length) {
        this(parent);
        this.value = value;
        this.length = length;
    }

    public BasicPhylogenyNode(BasicPhylogenyNode<T> parent, T value) {
        this(parent);
        this.value = value;
    }

    public BasicPhylogenyNode(BasicPhylogenyNode<T> parent, T value, Double length, Double weight) {
        this(parent);
        this.value = value;
        this.length = length;
        this.weight = weight;
    }

    public BasicPhylogenyNode(BasicPhylogenyNode<T> parent, PhylogenyNode<T> copyFrom) {
        this(parent, (Serializable)copyFrom.getPayload(), copyFrom.getLength(), copyFrom.getWeight());
    }

    @Override
    public List<BasicPhylogenyNode<T>> getChildren() {
        return this.children;
    }

    @Override
    @NotNull
    public PhylogenyNode<T> getChildWithPayload(T id) throws NoSuchNodeException {
        for (BasicPhylogenyNode<T> child : this.children) {
            if (child.getPayload() != id) continue;
            return child;
        }
        throw new NoSuchNodeException("Could not find child: " + id);
    }

    @Override
    public PhylogenyNode<T> getRandomLeafBelow() {
        PhylogenyNode<T> trav = this;
        List travChildren = trav.getChildren();
        while (!travChildren.isEmpty()) {
            trav = DSCollectionUtils.chooseRandom(travChildren);
            travChildren = trav.getChildren();
        }
        return trav;
    }

    @Override
    public boolean isLeaf() {
        return this.children.size() == 0;
    }

    @Override
    public Double getLength() {
        return this.length;
    }

    @Override
    public void setLength(Double length) {
        this.length = length;
        if (this.parent != null) {
            super.invalidateAggregatedChildInfo();
        }
    }

    @Override
    public void setWeight(Double weight) {
        this.weight = weight;
        if (this.parent != null) {
            super.invalidateAggregatedChildInfo();
        }
    }

    @Override
    @Nullable
    public Double getWeight() {
        if (this.weight == null) {
            if (this.isLeaf()) {
                return null;
            }
            this.propagateWeightFromBelow();
        }
        return this.weight;
    }

    @Override
    public Double getCurrentWeight() {
        return this.weight;
    }

    @Override
    public void incrementWeightBy(double v) {
        this.weight = this.weight == null ? v : this.weight + v;
    }

    private void propagateWeightFromBelow() {
        if (!this.isLeaf()) {
            this.weight = 0.0;
            for (BasicPhylogenyNode<T> child : this.children) {
                Double w = child.getWeight();
                if (w == null) {
                    throw new TreeRuntimeException("Can't propagate undefined weight");
                }
                this.incrementWeightBy(w);
            }
        }
    }

    @Override
    public double distanceToRoot() {
        return (this.length == null ? 0.0 : this.length) + (this.parent == null ? 0.0 : this.parent.distanceToRoot());
    }

    @Override
    public T getPayload() {
        return this.value;
    }

    @Override
    public void setPayload(T value) {
        if (value != null && value.equals(new Integer(-1))) {
            logger.error("wtf");
        }
        this.value = value;
    }

    @Override
    public BasicPhylogenyNode<T> getParent() {
        return this.parent;
    }

    @Override
    public BasicPhylogenyNode<T> findRoot() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.findRoot();
    }

    @Override
    public BasicRootedPhylogeny<T> asRootedPhylogeny() {
        return new BasicRootedPhylogeny(this);
    }

    @Override
    public PhylogenyNode<T> newChild(T payload) {
        BasicPhylogenyNode<T> child = new BasicPhylogenyNode<T>();
        child.setPayload(payload);
        child.setParent(this);
        return child;
    }

    @Override
    public final void setParent(PhylogenyNode<T> parent) {
        if (this.parent != null) {
            this.parent.unregisterChild(this);
        }
        this.parent = (BasicPhylogenyNode)parent;
        if (this.parent != null) {
            this.parent.registerChild(this);
        }
    }

    public void setBootstrap(double bootstrap) {
        this.bootstrap = bootstrap;
    }

    public int addSubtreeToMap(Map<T, BasicPhylogenyNode<T>> nodes, @NotNull NodeNamer<T> namer, int stackDepth) {
        int addedInternalNodes = 0;
        if (this.value != null) {
            if (nodes.get(this.value) != null) {
                Serializable uniqueValue = (Serializable)namer.uniqueify(this.value);
                logger.warn("Name " + this.value + " not unique, substituting " + uniqueValue);
                this.value = uniqueValue;
            }
            nodes.put(this.value, this);
        }
        assert (this.children != null);
        if (!namer.isAcceptable(this.value)) {
            this.assignGeneratedName(nodes, namer);
        } else if (!this.children.isEmpty() && namer.requireGeneratedNamesForInternalNodes()) {
            ++addedInternalNodes;
            logger.info("Adding phantom leaf for " + this.value);
            BasicPhylogenyNode<T> child = new BasicPhylogenyNode<T>();
            child.setPayload(this.value);
            child.setLength(0.0);
            child.setWeight(this.weight);
            child.parent = this;
            this.children.add(child);
            nodes.remove(this.value);
            assert (nodes.get(this.value) == null);
            this.setPayload((T)null);
            this.assignGeneratedName(nodes, namer);
        }
        for (BasicPhylogenyNode<T> n : this.children) {
            if (stackDepth > 2000) {
                logger.warn("Stack depth = " + stackDepth + " at node " + this.value);
            }
            addedInternalNodes += n.addSubtreeToMap(nodes, namer, stackDepth + 1);
        }
        return addedInternalNodes;
    }

    private void assignGeneratedName(Map<T, BasicPhylogenyNode<T>> nodes, NodeNamer<T> namer) {
        Serializable newValue = (Serializable)namer.generate();
        if (nodes.get(newValue) != null) {
            throw new TreeRuntimeException("Generated ID collided with a preexisting ID");
        }
        nodes.put(newValue, this);
        this.value = newValue;
    }

    public void appendToValue(String s, NodeNamer<T> namer) throws TreeException {
        this.value = this.value == null ? (Serializable)namer.create(s) : (Serializable)namer.merge(this.value, s);
    }

    public void appendToValue(Integer s, NodeNamer<T> namer) throws TreeException {
        this.value = this.value == null ? (Serializable)namer.create(s) : (Serializable)namer.merge(this.value, s);
    }

    @Override
    public List<? extends PhylogenyNode<T>> getAncestorPath() {
        return this.getAncestorPath(true);
    }

    @Override
    public List<PhylogenyNode<T>> getAncestorPath(boolean includeSelf) {
        if (this.ancestorPath == null) {
            PhylogenyNode<T> trav;
            LinkedList<PhylogenyNode<T>> result = new LinkedList<PhylogenyNode<T>>();
            PhylogenyNode<T> phylogenyNode = trav = includeSelf ? this : this.getParent();
            while (trav != null) {
                result.add(0, trav);
                trav = ((BasicPhylogenyNode)trav).getParent();
            }
            this.ancestorPath = Collections.unmodifiableList(result);
        }
        return this.ancestorPath;
    }

    @Override
    public List<T> getAncestorPathPayloads() {
        if (this.ancestorPathIds == null) {
            LinkedList<Object> result = new LinkedList<Object>();
            for (PhylogenyNode<T> trav = this; trav != null; trav = trav.getParent()) {
                result.add(0, trav.getPayload());
            }
            this.ancestorPathIds = Collections.unmodifiableList(result);
        }
        return this.ancestorPathIds;
    }

    @Override
    public Iterator<PhylogenyNode<T>> iterator() {
        return new DepthFirstTreeIteratorImpl(this);
    }

    @Override
    public DepthFirstTreeIterator<T, PhylogenyNode<T>> depthFirstIterator() {
        return new DepthFirstTreeIteratorImpl(this);
    }

    @Override
    public double getLargestLengthSpan() {
        this.computeDepthsIfNeeded();
        return this.largestLengthSpan;
    }

    @Override
    public double getGreatestBranchLengthDepthBelow() {
        this.computeDepthsIfNeeded();
        return this.greatestBranchLengthDepth;
    }

    public int getGreatestNodeDepthBelow() {
        this.computeDepthsIfNeeded();
        return this.greatestNodeDepth;
    }

    private void computeDepthsIfNeeded() {
        if (this.greatestBranchLengthDepth == null) {
            this.greatestBranchLengthDepth = 0.0;
            this.secondGreatestDepth = 0.0;
            this.largestLengthSpan = 0.0;
            this.greatestNodeDepth = 0;
            for (BasicPhylogenyNode<T> child : this.children) {
                int nodesBelow = child.getGreatestNodeDepthBelow() + 1;
                if (nodesBelow > this.greatestNodeDepth) {
                    this.greatestNodeDepth = nodesBelow;
                }
                if (child.length == null) continue;
                super.computeDepthsIfNeeded();
                if (child.length + child.greatestBranchLengthDepth > this.greatestBranchLengthDepth) {
                    this.secondGreatestDepth = this.greatestBranchLengthDepth;
                    this.greatestBranchLengthDepth = child.length + child.greatestBranchLengthDepth;
                } else if (child.length + child.greatestBranchLengthDepth > this.secondGreatestDepth) {
                    this.secondGreatestDepth = child.length + child.greatestBranchLengthDepth;
                }
                this.largestLengthSpan = Math.max(this.largestLengthSpan, this.greatestBranchLengthDepth + this.secondGreatestDepth);
                double spanViaChild = child.length + child.largestLengthSpan;
                this.largestLengthSpan = Math.max(this.largestLengthSpan, spanViaChild);
            }
        }
    }

    public void removeChild(BasicPhylogenyNode<T> child) {
        this.children.remove(child);
        child.setParent((PhylogenyNode<T>)null);
        this.invalidateAggregatedChildInfo();
    }

    @Override
    public void registerChild(PhylogenyNode<T> child) {
        if (!this.children.contains(child)) {
            this.children.add((BasicPhylogenyNode)child);
            this.invalidateAggregatedChildInfo();
        }
    }

    @Override
    public void unregisterChild(PhylogenyNode<T> child) {
        this.children.remove((BasicPhylogenyNode)child);
        this.invalidateAggregatedChildInfo();
    }

    private void invalidateAggregatedChildInfo() {
        assert (!this.children.isEmpty());
        if (this.greatestBranchLengthDepth != null || this.secondGreatestDepth != null || this.largestLengthSpan != null || this.weight != null) {
            this.greatestBranchLengthDepth = null;
            this.secondGreatestDepth = null;
            this.largestLengthSpan = null;
            this.weight = null;
            if (this.parent != null) {
                super.invalidateAggregatedChildInfo();
            }
        }
    }

    public String toString() {
        return this.value == null ? "null" : this.value.toString();
    }

    @Override
    public BasicPhylogenyNode<T> clone() {
        BasicPhylogenyNode result = null;
        try {
            result = (BasicPhylogenyNode)super.clone();
            this.parent = null;
            this.children = new ArrayList<BasicPhylogenyNode<T>>();
            for (BasicPhylogenyNode<T> child : this.children) {
                ((BasicPhylogenyNode)child.clone()).setParent(result);
            }
            result.setWeight(this.weight);
            return result;
        }
        catch (CloneNotSupportedException e) {
            logger.error("Error", e);
            throw new Error("cloneability required");
        }
    }

    public BasicPhylogenyNode<T> getSelfNode() {
        return this;
    }

    @Override
    public void appendSubtree(StringBuffer sb, String indent) {
        sb.append(indent + "\n");
        sb.append(indent + "---" + this.weight + " " + this.length + "     " + this.value + "\n");
        indent = indent + "   |";
        for (BasicPhylogenyNode n : this.getChildren()) {
            n.appendSubtree(sb, indent);
        }
    }

    @Override
    public PhylogenyNode<T> nearestAncestorWithBranchLength() throws NoSuchNodeException {
        PhylogenyNode<T> n = this;
        while (n.getLength() == null) {
            if ((n = n.getParent()) != null) continue;
            throw new NoSuchNodeException("No ancestor of " + this.getPayload() + " has a branch length.");
        }
        return n;
    }
}

