/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.trees;

import com.davidsoergel.trees.AbstractRootedPhylogeny;
import com.davidsoergel.trees.BasicPhylogenyNode;
import com.davidsoergel.trees.DepthFirstTreeIterator;
import com.davidsoergel.trees.NoSuchNodeException;
import com.davidsoergel.trees.NodeNamer;
import com.davidsoergel.trees.PhylogenyNode;
import com.davidsoergel.trees.RequireExistingNodeNamer;
import com.davidsoergel.trees.RootedPhylogeny;
import com.davidsoergel.trees.SerializableRootedPhylogeny;
import com.davidsoergel.trees.TreeException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.NotImplementedException;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicRootedPhylogeny<T extends Serializable>
extends AbstractRootedPhylogeny<T>
implements SerializableRootedPhylogeny<T> {
    private static final long serialVersionUID = 20090904L;
    private static final Logger logger = Logger.getLogger(BasicRootedPhylogeny.class);
    private transient Map<T, BasicPhylogenyNode<T>> uniqueIdToNodeMap;
    BasicPhylogenyNode<T> root;
    private Set<PhylogenyNode<T>> leafSet = null;
    private Set<T> leafIds = null;

    public BasicRootedPhylogeny() {
        this.root = new BasicPhylogenyNode();
    }

    public BasicRootedPhylogeny(T rootValue) {
        this.root = new BasicPhylogenyNode<T>(null, rootValue, 0.0);
    }

    public BasicRootedPhylogeny(BasicPhylogenyNode<T> root) {
        this.root = root;
        this.assignUniqueIds(new RequireExistingNodeNamer(true));
    }

    @Override
    public void toNewick(StringBuffer sb, String prefix, String tab, int minClusterSize, double minLabelProb) {
        this.root.toNewick(sb, prefix, tab, minClusterSize, minLabelProb);
        sb.append(";\n");
    }

    @Override
    public String toString() {
        return "BasicRootedPhylogeny{" + this.root + '}';
    }

    @Override
    @NotNull
    public BasicPhylogenyNode<T> getNode(T name) throws NoSuchNodeException {
        BasicPhylogenyNode<T> result = this.uniqueIdToNodeMap.get(name);
        if (result == null) {
            throw new NoSuchNodeException("Node not found: " + name);
        }
        return result;
    }

    @Override
    public double getWeight(T id) throws NoSuchNodeException {
        Double w;
        try {
            PhylogenyNode aNode = this.getNode((Serializable)id);
            w = aNode.getWeight();
        }
        catch (NoSuchNodeException e) {
            return 0.0;
        }
        if (w == null) {
            throw new NoSuchNodeException("The node " + id + " exists, but has unspecified weight");
        }
        return w;
    }

    @Override
    public Map<T, ? extends PhylogenyNode<T>> getUniqueIdToNodeMap() {
        return this.uniqueIdToNodeMap;
    }

    public void putUniqueIdToNode(T id, BasicPhylogenyNode<T> node) {
        this.uniqueIdToNodeMap.put(id, node);
    }

    @Override
    public Collection<PhylogenyNode<T>> getLeaves() {
        if (this.leafSet == null) {
            this.leafSet = new HashSet<PhylogenyNode<T>>();
            this.leafIds = new HashSet<T>();
            for (Serializable t : this.uniqueIdToNodeMap.keySet()) {
                PhylogenyNode node = this.uniqueIdToNodeMap.get(t);
                if (!node.isLeaf()) continue;
                this.leafSet.add(node);
                this.leafIds.add(t);
            }
        }
        return this.leafSet;
    }

    @Override
    public Set<T> getLeafValues() {
        if (this.leafIds == null) {
            this.getLeaves();
        }
        return this.leafIds;
    }

    public void addNode(BasicPhylogenyNode<T> n) throws TreeException {
        if (this.uniqueIdToNodeMap.get(n.getPayload()) != null) {
            throw new TreeException("Node id not unique");
        }
        this.uniqueIdToNodeMap.put(n.getPayload(), n);
        this.leafIds = null;
        this.leafSet = null;
    }

    @Override
    public Set<T> getNodeValues() {
        return this.uniqueIdToNodeMap.keySet();
    }

    public void assignUniqueIds(@NotNull NodeNamer<T> namer) {
        this.uniqueIdToNodeMap = new HashMap<T, BasicPhylogenyNode<T>>();
        int addedInternalNodes = this.root.addSubtreeToMap(this.uniqueIdToNodeMap, namer, 1);
        if (logger.isDebugEnabled() && addedInternalNodes != 0) {
            logger.debug("Added " + addedInternalNodes + " internal nodes to satisfy namer requirement");
        }
    }

    @Override
    public List<BasicPhylogenyNode<T>> getChildren() {
        return this.root.getChildren();
    }

    @Override
    @NotNull
    public PhylogenyNode<T> getChildWithPayload(T id) throws NoSuchNodeException {
        return this.root.getChildWithPayload(id);
    }

    @Override
    public T getPayload() {
        return (T)this.root.getPayload();
    }

    @Override
    @Nullable
    public PhylogenyNode getParent() {
        return null;
    }

    @Override
    public PhylogenyNode<T> newChild(T payload) {
        return this.root.newChild(payload);
    }

    @Override
    public void setPayload(T contents) {
        this.root.setPayload(contents);
    }

    @Override
    public void setParent(PhylogenyNode<T> parent) {
        logger.error("Can't set the parent of the root node");
    }

    @Override
    public List<PhylogenyNode<T>> getAncestorPath(boolean includeSelf) {
        LinkedList<BasicPhylogenyNode<T>> result = new LinkedList<BasicPhylogenyNode<T>>();
        if (includeSelf) {
            result.add(0, this.root);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<PhylogenyNode<T>> getAncestorPath() {
        return this.getAncestorPath(true);
    }

    @Override
    public BasicPhylogenyNode<T> getFirstBranchingNode() {
        PhylogenyNode r = this.getRoot();
        while (((BasicPhylogenyNode)r).getChildren().size() == 1) {
            r = (BasicPhylogenyNode)((BasicPhylogenyNode)r).getChildren().iterator().next();
        }
        return r;
    }

    @Override
    public List<T> getAncestorPathPayloads() {
        LinkedList<Object> result = new LinkedList<Object>();
        result.add(0, ((BasicPhylogenyNode)this.getRoot()).getPayload());
        return Collections.unmodifiableList(result);
    }

    @Override
    public Double getLength() {
        return 0.0;
    }

    @Override
    public void setLength(Double d) {
        logger.error("Can't set length of the root node");
    }

    @Override
    public double getLargestLengthSpan() {
        return this.root.getLargestLengthSpan();
    }

    @Override
    public double getGreatestBranchLengthDepthBelow() {
        return this.root.getGreatestBranchLengthDepthBelow();
    }

    public int getGreatestNodeDepthBelow() {
        return this.root.getGreatestNodeDepthBelow();
    }

    @Override
    public void registerChild(PhylogenyNode<T> a) {
        this.root.registerChild(a);
    }

    @Override
    public void unregisterChild(PhylogenyNode<T> a) {
        this.root.unregisterChild(a);
    }

    @Override
    public Iterator<PhylogenyNode<T>> iterator() {
        return this.root.iterator();
    }

    @Override
    public DepthFirstTreeIterator<T, PhylogenyNode<T>> depthFirstIterator() {
        return this.root.depthFirstIterator();
    }

    @Override
    public T nearestKnownAncestor(RootedPhylogeny<T> rootPhylogeny, T leafId) throws NoSuchNodeException {
        Serializable result = null;
        if (result == null) {
            PhylogenyNode n = this.getNode((Serializable)leafId);
            while (true) {
                try {
                    rootPhylogeny.getNode((Serializable)n.getPayload());
                }
                catch (NoSuchNodeException e) {
                    if ((n = n.getParent()) != null) continue;
                    throw new NoSuchNodeException("Taxon " + leafId + " not found in tree.");
                }
                break;
            }
            result = (Serializable)n.getPayload();
        }
        return (T)result;
    }

    @Override
    public T nearestAncestorWithBranchLength(T leafId) throws NoSuchNodeException {
        PhylogenyNode n = this.getNode((Serializable)leafId);
        return (T)((Serializable)n.nearestAncestorWithBranchLength().getPayload());
    }

    @Override
    public BasicPhylogenyNode<T> getRoot() {
        return this.root;
    }

    @Override
    public BasicPhylogenyNode<T> findRoot() {
        return this.root;
    }

    @Override
    public boolean isLeaf() {
        return this.root.isLeaf();
    }

    @Override
    public Double getWeight() {
        return 1.0;
    }

    @Override
    public Double getCurrentWeight() {
        return 1.0;
    }

    @Override
    public void setWeight(Double v) {
        if (v != 1.0) {
            throw new Error("Can't set root weight to anything other than 1");
        }
    }

    @Override
    public void incrementWeightBy(double v) {
        throw new Error("Can't increment root weight");
    }

    @Override
    public double distanceToRoot() {
        return 0.0;
    }

    public void setRoot(BasicPhylogenyNode<T> root) {
        this.root = root;
    }

    @Override
    public BasicRootedPhylogeny<T> clone() {
        BasicRootedPhylogeny<T> result = new BasicRootedPhylogeny<T>();
        result.setRoot((BasicPhylogenyNode<T>)this.root.clone());
        result.setBasePhylogeny(this.getBasePhylogeny());
        result.assignUniqueIds(null);
        return result;
    }

    public boolean equalValue(RootedPhylogeny<T> other) {
        throw new NotImplementedException();
    }

    public String getId() {
        return this.root.getPayload().toString();
    }

    public BasicPhylogenyNode<T> getSelfNode() {
        return this.root;
    }

    @Override
    public void appendSubtree(StringBuffer sb, String indent) {
        this.root.appendSubtree(sb, indent);
    }

    private Object readResolve() throws ObjectStreamException {
        this.uniqueIdToNodeMap = new HashMap<T, BasicPhylogenyNode<T>>();
        this.assignUniqueIds(new RequireExistingNodeNamer(false));
        for (BasicPhylogenyNode<T> p : this.uniqueIdToNodeMap.values()) {
            for (PhylogenyNode<T> c : p.getChildren()) {
                c.setParent(p);
            }
        }
        return this;
    }

    @Override
    public PhylogenyNode<T> nearestAncestorWithBranchLength() throws NoSuchNodeException {
        throw new NoSuchNodeException("Root doesn't have a branch length.");
    }

    @Override
    @NotNull
    public BasicRootedPhylogeny<T> extractTreeWithLeafIDs(Set<T> ids, boolean ignoreAbsentNodes, boolean includeInternalBranches, AbstractRootedPhylogeny.MutualExclusionResolutionMode mode) throws NoSuchNodeException {
        if (((Object)this.getLeafValues()).equals(ids) && includeInternalBranches) {
            return this;
        }
        return super.extractTreeWithLeafIDs(ids, ignoreAbsentNodes, includeInternalBranches, mode);
    }
}

