/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.trees;

import com.davidsoergel.trees.NodeNamer;
import com.davidsoergel.trees.TreeException;
import com.davidsoergel.trees.TreeRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerNodeNamer
implements NodeNamer<Integer> {
    private int currentId;
    boolean requireGeneratedNamesForInternalNodes = false;

    public IntegerNodeNamer(int unknownBasis, boolean requireGeneratedNamesForInternalNodes) {
        this.currentId = unknownBasis;
        this.requireGeneratedNamesForInternalNodes = requireGeneratedNamesForInternalNodes;
    }

    @Override
    public boolean requireGeneratedNamesForInternalNodes() {
        return this.requireGeneratedNamesForInternalNodes;
    }

    @Override
    public Integer merge(Integer name, String s) throws TreeException {
        throw new TreeException("Cannot merge integer IDs");
    }

    @Override
    public Integer merge(Integer name, Integer s) throws TreeException {
        throw new TreeException("Cannot merge integer IDs");
    }

    @Override
    public Integer create(Integer s) {
        return s;
    }

    @Override
    public Integer create(String s) throws TreeException {
        try {
            return new Integer(s);
        }
        catch (NumberFormatException e) {
            throw new TreeException(e, "Non-integer ID found.");
        }
    }

    @Override
    public Integer generate() {
        return this.currentId++;
    }

    @Override
    public Integer uniqueify(Integer value) {
        return this.generate();
    }

    @Override
    public boolean isAcceptable(Integer value) {
        return value != null;
    }

    @Override
    public Integer makeAggregate(Integer newValue, Integer value) {
        throw new TreeRuntimeException("Can't aggregate Integer IDs");
    }
}

