/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.trees;

import com.davidsoergel.trees.AbstractHierarchyNode;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListHierarchyNode<T>
extends AbstractHierarchyNode<T, ListHierarchyNode<T>>
implements Serializable {
    private List<ListHierarchyNode<T>> children = new ArrayList<ListHierarchyNode<T>>();

    public ListHierarchyNode(T contents) {
        super(contents);
    }

    public ListHierarchyNode() {
    }

    @Override
    public void registerChild(ListHierarchyNode<T> child) {
        this.children.add(child);
    }

    @Override
    public void unregisterChild(ListHierarchyNode<T> child) {
        this.children.remove(child);
    }

    @Override
    public List<? extends ListHierarchyNode<T>> getChildren() {
        return this.children;
    }

    @Override
    public ListHierarchyNode<T> newChild(T payload) {
        ListHierarchyNode<T> result = new ListHierarchyNode<T>();
        result.setPayload(payload);
        result.setParent(this);
        return result;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.payload = stream.readObject();
        this.children = (List)stream.readObject();
        for (ListHierarchyNode<T> child : this.children) {
            child.setParent(this);
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.payload);
        stream.writeObject(this.children);
    }
}

