/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.jlibsvm;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import edu.berkeley.compbio.jlibsvm.SvmProblem;
import edu.berkeley.compbio.jlibsvm.scaler.ScalingModel;
import edu.berkeley.compbio.jlibsvm.scaler.ScalingModelLearner;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSvmProblem<L extends Comparable, P, R extends SvmProblem<L, P, R>>
implements SvmProblem<L, P, R> {
    protected Multiset<L> exampleCounts = null;

    @Override
    public Multiset<L> getExampleCounts() {
        if (this.exampleCounts == null) {
            this.exampleCounts = HashMultiset.create();
            this.exampleCounts.addAll(this.getExamples().values());
        }
        return this.exampleCounts;
    }

    protected R learnScaling(ScalingModelLearner<P> scalingModelLearner) {
        Map examples = this.getExamples();
        Map exampleIds = this.getExampleIds();
        ScalingModel learnedScalingModel = scalingModelLearner.learnScaling(examples.keySet());
        Map unscaledExamples = this.getExamples();
        HashMap scaledExamples = new HashMap(examples.size());
        HashMap<P, Integer> scaledExampleIds = new HashMap<P, Integer>(exampleIds.size());
        for (Map.Entry entry : unscaledExamples.entrySet()) {
            P scaledPoint = learnedScalingModel.scaledCopy(entry.getKey());
            scaledExamples.put(scaledPoint, entry.getValue());
            scaledExampleIds.put(scaledPoint, exampleIds.get(entry.getKey()));
        }
        return this.createScaledCopy(scaledExamples, scaledExampleIds, learnedScalingModel);
    }

    public abstract R createScaledCopy(Map<P, L> var1, Map<P, Integer> var2, ScalingModel<P> var3);
}

