/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.jlibsvm;

import com.davidsoergel.dsutils.collections.MappingIterator;
import edu.berkeley.compbio.jlibsvm.AbstractSvmProblem;
import edu.berkeley.compbio.jlibsvm.ExplicitSvmProblem;
import edu.berkeley.compbio.jlibsvm.SvmProblem;
import edu.berkeley.compbio.jlibsvm.scaler.NoopScalingModel;
import edu.berkeley.compbio.jlibsvm.scaler.ScalingModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExplicitSvmProblemImpl<L extends Comparable, P, R extends SvmProblem<L, P, R>>
extends AbstractSvmProblem<L, P, R>
implements ExplicitSvmProblem<L, P, R> {
    public Map<P, L> examples;
    public Map<P, Integer> exampleIds;
    public ScalingModel<P> scalingModel = new NoopScalingModel();
    protected List<L> labels = null;
    protected Set<P> heldOutPoints = new HashSet<P>();

    protected ExplicitSvmProblemImpl(Map<P, L> examples, @NotNull Map<P, Integer> exampleIds) {
        this.examples = examples;
        this.exampleIds = exampleIds;
    }

    protected ExplicitSvmProblemImpl(Map<P, L> examples, @NotNull Map<P, Integer> exampleIds, @NotNull ScalingModel<P> scalingModel) {
        this.examples = examples;
        this.exampleIds = exampleIds;
        this.scalingModel = scalingModel;
    }

    protected ExplicitSvmProblemImpl(Map<P, L> examples, @NotNull Map<P, Integer> exampleIds, @NotNull ScalingModel<P> scalingModel, Set<P> heldOutPoints) {
        this.examples = examples;
        this.exampleIds = exampleIds;
        this.scalingModel = scalingModel;
        this.heldOutPoints = heldOutPoints;
    }

    @Override
    @NotNull
    public Map<P, Integer> getExampleIds() {
        return this.exampleIds;
    }

    @Override
    @NotNull
    public Map<P, L> getExamples() {
        return this.examples;
    }

    @Override
    public List<L> getLabels() {
        if (this.labels == null) {
            if (this.examples.isEmpty()) {
                return null;
            }
            HashSet<L> uniq = new HashSet<L>(this.examples.values());
            this.labels = new ArrayList<L>(uniq);
            Collections.sort(this.labels);
        }
        return this.labels;
    }

    @Override
    @NotNull
    public ScalingModel<P> getScalingModel() {
        return this.scalingModel;
    }

    @Override
    public Iterator<R> makeFolds(int numberOfFolds) {
        ArrayList<P> points = new ArrayList<P>(this.getExamples().keySet());
        Collections.shuffle(points);
        ArrayList heldOutPointSets = new ArrayList();
        for (int i = 0; i < numberOfFolds; ++i) {
            heldOutPointSets.add(new HashSet());
        }
        int f = 0;
        for (Object point2 : points) {
            ((Set)heldOutPointSets.get(f)).add(point2);
            ++f;
            f %= numberOfFolds;
        }
        MappingIterator foldIterator = new MappingIterator<Set<P>, R>(heldOutPointSets.iterator()){

            @Override
            public R function(Set<P> p) {
                return ExplicitSvmProblemImpl.this.makeFold(p);
            }
        };
        return foldIterator;
    }

    @Override
    public int getId(P key) {
        return this.exampleIds.get(key);
    }

    @Override
    public L getTargetValue(P point2) {
        return (L)((Comparable)this.examples.get(point2));
    }

    @Override
    public int getNumExamples() {
        return this.examples.size();
    }

    @Override
    public Set<P> getHeldOutPoints() {
        return this.heldOutPoints;
    }

    protected abstract R makeFold(Set<P> var1);
}

