/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.jlibsvm;

import edu.berkeley.compbio.jlibsvm.multi.MultiClassModel;
import edu.berkeley.compbio.jlibsvm.scaler.ScalingModelLearner;
import java.util.Collection;
import java.util.LinkedHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ImmutableSvmParameter<L extends Comparable, P> {
    public final float cache_size;
    public final float eps;
    public final float nu;
    public final float p;
    public final boolean shrinking;
    public final double oneVsAllThreshold;
    public final MultiClassModel.OneVsAllMode oneVsAllMode;
    public final MultiClassModel.AllVsAllMode allVsAllMode;
    public final double minVoteProportion;
    public final int falseClassSVlimit;
    public final boolean redistributeUnbalancedC;
    public final boolean scaleBinaryMachinesIndependently;
    public final boolean gridsearchBinaryMachinesIndependently;
    public final boolean normalizeL2;
    public final int crossValidationFolds;
    public final ScalingModelLearner<P> scalingModelLearner;
    public final boolean probability;
    private final LinkedHashMap<L, Float> weights;

    protected ImmutableSvmParameter(Builder<L, P> copyFrom) {
        this.cache_size = copyFrom.cache_size;
        this.eps = copyFrom.eps;
        this.weights = new LinkedHashMap(copyFrom.weights);
        this.nu = copyFrom.nu;
        this.p = copyFrom.p;
        this.shrinking = copyFrom.shrinking;
        this.probability = copyFrom.probability;
        this.oneVsAllThreshold = copyFrom.oneVsAllThreshold;
        this.oneVsAllMode = copyFrom.oneVsAllMode;
        this.allVsAllMode = copyFrom.allVsAllMode;
        this.minVoteProportion = copyFrom.minVoteProportion;
        this.falseClassSVlimit = copyFrom.falseClassSVlimit;
        this.scaleBinaryMachinesIndependently = copyFrom.scaleBinaryMachinesIndependently;
        this.normalizeL2 = copyFrom.normalizeL2;
        this.redistributeUnbalancedC = copyFrom.redistributeUnbalancedC;
        this.gridsearchBinaryMachinesIndependently = copyFrom.gridsearchBinaryMachinesIndependently;
        this.scalingModelLearner = copyFrom.scalingModelLearner;
        this.crossValidationFolds = copyFrom.crossValidationFolds;
    }

    public int getCacheRows() {
        double mb = this.cache_size;
        double kb = mb * 1024.0;
        double bytes = kb * 1024.0;
        double floats = bytes / 4.0;
        double floatrows = Math.sqrt(floats);
        return (int)floatrows;
    }

    public Collection<L> getLabels() {
        return this.weights.keySet();
    }

    public Float getWeight(L key) {
        return this.weights.get(key);
    }

    public boolean isWeightsEmpty() {
        return this.weights.isEmpty();
    }

    public ImmutableSvmParameter<L, P> noProbabilityCopy() {
        if (!this.probability) {
            return this;
        }
        Builder<L, P> builder = this.asBuilder();
        builder.probability = false;
        return builder.build();
    }

    public ImmutableSvmParameter<L, P> withProbabilityCopy() {
        if (this.probability) {
            return this;
        }
        Builder<L, P> builder = this.asBuilder();
        builder.probability = true;
        return builder.build();
    }

    public abstract Builder<L, P> asBuilder();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Builder<L extends Comparable, P> {
        public float cache_size;
        public float eps;
        public float nu;
        public float p;
        public boolean shrinking;
        public double oneVsAllThreshold = 0.5;
        public MultiClassModel.OneVsAllMode oneVsAllMode = MultiClassModel.OneVsAllMode.None;
        public MultiClassModel.AllVsAllMode allVsAllMode = MultiClassModel.AllVsAllMode.AllVsAll;
        public double minVoteProportion;
        public int falseClassSVlimit = Integer.MAX_VALUE;
        public boolean redistributeUnbalancedC = true;
        public boolean scaleBinaryMachinesIndependently = false;
        public boolean gridsearchBinaryMachinesIndependently = false;
        public boolean normalizeL2 = false;
        public int crossValidationFolds = 5;
        public boolean probability;
        public LinkedHashMap<L, Float> weights = new LinkedHashMap();
        public ScalingModelLearner<P> scalingModelLearner;

        public Builder() {
        }

        protected Builder(ImmutableSvmParameter<L, P> copyFrom) {
            this.cache_size = copyFrom.cache_size;
            this.eps = copyFrom.eps;
            this.weights = new LinkedHashMap(((ImmutableSvmParameter)copyFrom).weights);
            this.nu = copyFrom.nu;
            this.p = copyFrom.p;
            this.shrinking = copyFrom.shrinking;
            this.probability = copyFrom.probability;
            this.oneVsAllThreshold = copyFrom.oneVsAllThreshold;
            this.oneVsAllMode = copyFrom.oneVsAllMode;
            this.allVsAllMode = copyFrom.allVsAllMode;
            this.minVoteProportion = copyFrom.minVoteProportion;
            this.falseClassSVlimit = copyFrom.falseClassSVlimit;
            this.scaleBinaryMachinesIndependently = copyFrom.scaleBinaryMachinesIndependently;
            this.normalizeL2 = copyFrom.normalizeL2;
            this.redistributeUnbalancedC = copyFrom.redistributeUnbalancedC;
            this.gridsearchBinaryMachinesIndependently = copyFrom.gridsearchBinaryMachinesIndependently;
            this.crossValidationFolds = copyFrom.crossValidationFolds;
            this.scalingModelLearner = copyFrom.scalingModelLearner;
        }

        protected Builder(Builder<L, P> copyFrom) {
            this.cache_size = copyFrom.cache_size;
            this.eps = copyFrom.eps;
            this.weights = new LinkedHashMap<L, Float>(copyFrom.weights);
            this.nu = copyFrom.nu;
            this.p = copyFrom.p;
            this.shrinking = copyFrom.shrinking;
            this.probability = copyFrom.probability;
            this.oneVsAllThreshold = copyFrom.oneVsAllThreshold;
            this.oneVsAllMode = copyFrom.oneVsAllMode;
            this.allVsAllMode = copyFrom.allVsAllMode;
            this.minVoteProportion = copyFrom.minVoteProportion;
            this.falseClassSVlimit = copyFrom.falseClassSVlimit;
            this.scaleBinaryMachinesIndependently = copyFrom.scaleBinaryMachinesIndependently;
            this.normalizeL2 = copyFrom.normalizeL2;
            this.redistributeUnbalancedC = copyFrom.redistributeUnbalancedC;
            this.gridsearchBinaryMachinesIndependently = copyFrom.gridsearchBinaryMachinesIndependently;
            this.crossValidationFolds = copyFrom.crossValidationFolds;
            this.scalingModelLearner = copyFrom.scalingModelLearner;
        }

        public void putWeight(L key, Float weight) {
            this.weights.put(key, weight);
        }

        public abstract ImmutableSvmParameter<L, P> build();
    }
}

