/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.jlibsvm;

import com.davidsoergel.conja.Function;
import com.davidsoergel.conja.Parallel;
import edu.berkeley.compbio.jlibsvm.ContinuousModel;
import edu.berkeley.compbio.jlibsvm.DiscreteModel;
import edu.berkeley.compbio.jlibsvm.ImmutableSvmParameter;
import edu.berkeley.compbio.jlibsvm.SolutionModel;
import edu.berkeley.compbio.jlibsvm.SvmContext;
import edu.berkeley.compbio.jlibsvm.SvmException;
import edu.berkeley.compbio.jlibsvm.SvmProblem;
import edu.berkeley.compbio.ml.CrossValidationResults;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SVM<L extends Comparable, P, R extends SvmProblem<L, P, R>>
extends SvmContext {
    private static final Logger logger = Logger.getLogger(SVM.class);
    public static final int LIBSVM_VERSION = 288;

    public Map<P, Float> continuousCrossValidation(SvmProblem<L, P, R> problem, final ImmutableSvmParameter<L, P> param) {
        final ConcurrentHashMap predictions = new ConcurrentHashMap();
        if (param.crossValidationFolds >= problem.getNumExamples()) {
            throw new SvmException("Can't have more cross-validation folds than there are examples");
        }
        Iterator<R> foldIterator = problem.makeFolds(param.crossValidationFolds);
        Parallel.forEach(foldIterator, new Function<R, Void>(){

            @Override
            public Void apply(R f) {
                ContinuousModel model = (ContinuousModel)((Object)SVM.this.train(f, param));
                for (Object p : f.getHeldOutPoints()) {
                    predictions.put(p, model.predictValue(p));
                }
                return null;
            }
        });
        return predictions;
    }

    public abstract SolutionModel<L, P> train(R var1, ImmutableSvmParameter<L, P> var2);

    public Map<P, L> discreteCrossValidation(SvmProblem<L, P, R> problem, final ImmutableSvmParameter<L, P> param) {
        final ConcurrentHashMap predictions = new ConcurrentHashMap();
        final ConcurrentSkipListSet nullPredictionPoints = new ConcurrentSkipListSet();
        if (param.crossValidationFolds >= problem.getNumExamples()) {
            throw new SvmException("Can't have more cross-validation folds than there are examples");
        }
        Iterator<R> foldIterator = problem.makeFolds(param.crossValidationFolds);
        Parallel.forEach(foldIterator, new Function<R, Void>(){

            @Override
            public Void apply(R f) {
                DiscreteModel model = (DiscreteModel)((Object)SVM.this.train(f, param));
                for (Object p : f.getHeldOutPoints()) {
                    Comparable prediction = (Comparable)model.predictLabel(p);
                    if (prediction == null) {
                        nullPredictionPoints.add(p);
                        continue;
                    }
                    predictions.put(p, prediction);
                }
                return null;
            }
        });
        HashMap result = new HashMap(predictions);
        for (Object nullPredictionPoint : nullPredictionPoints) {
            result.put(nullPredictionPoint, null);
        }
        return result;
    }

    public abstract String getSvmType();

    public void validateParam(@NotNull ImmutableSvmParameter<L, P> param) {
        if (param.eps < 0.0f) {
            throw new SvmException("eps < 0");
        }
    }

    public abstract CrossValidationResults performCrossValidation(R var1, ImmutableSvmParameter<L, P> var2);
}

