/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.jlibsvm;

import org.apache.log4j.Logger;

public class SigmoidProbabilityModel {
    private static final Logger logger = Logger.getLogger(SigmoidProbabilityModel.class);
    float A;
    float B;

    public SigmoidProbabilityModel(float[] decisionValues, boolean[] labels) {
        int iter;
        float fApB;
        int l = decisionValues.length;
        float prior1 = 0.0f;
        float prior0 = 0.0f;
        for (boolean b : labels) {
            if (b) {
                prior1 += 1.0f;
                continue;
            }
            prior0 += 1.0f;
        }
        int maximumIterations = 100;
        float minStep = 1.0E-10f;
        float sigma = 1.0E-12f;
        float eps = 1.0E-5f;
        float hiTarget = (prior1 + 1.0f) / (prior1 + 2.0f);
        float loTarget = 1.0f / (prior0 + 2.0f);
        float[] t = new float[l];
        this.A = 0.0f;
        this.B = (float)Math.log((prior0 + 1.0f) / (prior1 + 1.0f));
        float fval = 0.0f;
        for (int i = 0; i < l; ++i) {
            t[i] = labels[i] ? hiTarget : loTarget;
            fApB = decisionValues[i] * this.A + this.B;
            fval = fApB >= 0.0f ? (float)((double)fval + ((double)(t[i] * fApB) + Math.log(1.0 + Math.exp(-fApB)))) : (float)((double)fval + ((double)((t[i] - 1.0f) * fApB) + Math.log(1.0 + Math.exp(fApB))));
        }
        for (iter = 0; iter < maximumIterations; ++iter) {
            float stepsize;
            int i;
            float h11 = sigma;
            float h22 = sigma;
            float h21 = 0.0f;
            float g1 = 0.0f;
            float g2 = 0.0f;
            for (i = 0; i < l; ++i) {
                double q;
                double p;
                double expfApB;
                fApB = decisionValues[i] * this.A + this.B;
                if (fApB >= 0.0f) {
                    expfApB = Math.exp(-fApB);
                    p = expfApB / (1.0 + expfApB);
                    q = 1.0 / (1.0 + expfApB);
                } else {
                    expfApB = Math.exp(fApB);
                    p = 1.0 / (1.0 + expfApB);
                    q = expfApB / (1.0 + expfApB);
                }
                float d2 = (float)(p * q);
                h11 += decisionValues[i] * decisionValues[i] * d2;
                h22 += d2;
                h21 += decisionValues[i] * d2;
                float d1 = (float)((double)t[i] - p);
                g1 += decisionValues[i] * d1;
                g2 += d1;
            }
            if (Math.abs(g1) < eps && Math.abs(g2) < eps) break;
            float det = h11 * h22 - h21 * h21;
            float dA = -(h22 * g1 - h21 * g2) / det;
            float dB = -(-h21 * g1 + h11 * g2) / det;
            float gd = g1 * dA + g2 * dB;
            for (stepsize = 1.0f; stepsize >= minStep; stepsize /= 2.0f) {
                float newA = this.A + stepsize * dA;
                float newB = this.B + stepsize * dB;
                float newf = 0.0f;
                for (i = 0; i < l; ++i) {
                    fApB = decisionValues[i] * newA + newB;
                    newf = fApB >= 0.0f ? (float)((double)newf + ((double)(t[i] * fApB) + Math.log(1.0 + Math.exp(-fApB)))) : (float)((double)newf + ((double)((t[i] - 1.0f) * fApB) + Math.log(1.0 + Math.exp(fApB))));
                }
                if (!((double)newf < (double)fval + 1.0E-4 * (double)stepsize * (double)gd)) continue;
                this.A = newA;
                this.B = newB;
                fval = newf;
                break;
            }
            if (!(stepsize < minStep)) continue;
            logger.error("Line search fails in two-class probability estimates");
            break;
        }
        if (iter >= maximumIterations) {
            logger.error("Reaching maximal iterations in two-class probability estimates");
        }
    }

    public float predict(float decisionValue) {
        float fApB = decisionValue * this.A + this.B;
        if (fApB >= 0.0f) {
            double expMinusfApB = Math.exp(-fApB);
            return (float)(expMinusfApB / (1.0 + expMinusfApB));
        }
        return (float)(1.0 / (1.0 + Math.exp(fApB)));
    }
}

