/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.jlibsvm;

import edu.berkeley.compbio.jlibsvm.SvmContext;
import edu.berkeley.compbio.jlibsvm.SvmException;
import edu.berkeley.compbio.ml.CrossValidationResults;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringBufferInputStream;
import java.util.Collection;
import java.util.Properties;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SolutionModel<L extends Comparable, P>
extends SvmContext {
    public String svmType;

    public abstract CrossValidationResults getCrossValidationResults();

    public static SolutionModel identifyTypeAndLoad(String model_file_name) {
        try {
            BufferedReader fp = new BufferedReader(new FileReader(model_file_name));
            Properties props = new Properties();
            props.load(new StringBufferInputStream(SolutionModel.readUpToSVs(fp)));
            Class<?> c = Class.forName(props.getProperty("svm_type"));
            SolutionModel model = (SolutionModel)c.getConstructor(Properties.class).newInstance(props);
            model.readSupportVectors(fp);
            fp.close();
            return model;
        }
        catch (Throwable e) {
            throw new SvmException("Unable to load file " + model_file_name, e);
        }
    }

    private static String readUpToSVs(BufferedReader reader) throws IOException {
        String l;
        StringBuffer sb = new StringBuffer();
        while (!(l = reader.readLine()).startsWith("SV")) {
            sb.append(l);
        }
        return sb.toString();
    }

    protected abstract void readSupportVectors(BufferedReader var1) throws IOException;

    public void setSvmType(String svmType) {
        this.svmType = svmType;
    }

    public void save(String model_file_name) throws IOException {
        DataOutputStream fp = new DataOutputStream(new FileOutputStream(model_file_name));
        this.writeToStream(fp);
    }

    public void writeToStream(DataOutputStream fp) throws IOException {
        throw new NotImplementedException();
    }

    public Collection<L> getLabels() {
        throw new NotImplementedException();
    }
}

