/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.jlibsvm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolutionVector<P>
implements Comparable<SolutionVector> {
    public int rank = -1;
    public int id;
    public P point;
    public boolean targetValue;
    public double alpha;
    public double G;
    public float linearTerm;
    Status alphaStatus;
    float G_bar;

    public SolutionVector(P key, Boolean targetValue, float linearTerm) {
        this.point = key;
        this.linearTerm = linearTerm;
        this.targetValue = targetValue;
    }

    public SolutionVector(P key, Boolean value, float linearTerm, float alpha) {
        this(key, value, linearTerm);
        this.alpha = alpha;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SolutionVector that = (SolutionVector)o;
        return this.rank == that.rank;
    }

    public int hashCode() {
        return this.id;
    }

    public String toString() {
        return "SolutionVector{point=" + this.point + ", targetValue=" + this.targetValue + ", alpha=" + this.alpha + ", alphaStatus=" + (Object)((Object)this.alphaStatus) + ", G=" + this.G + ", linearTerm=" + this.linearTerm + ", G_bar=" + this.G_bar + '}';
    }

    @Override
    public int compareTo(SolutionVector b) {
        return this.rank < b.rank ? -1 : (this.rank > b.rank ? 1 : 0);
    }

    boolean isFree() {
        return this.alphaStatus == Status.FREE;
    }

    public boolean isShrinkable(double Gmax1, double Gmax2) {
        if (this.isUpperBound()) {
            if (this.targetValue) {
                return -this.G > Gmax1;
            }
            return -this.G > Gmax2;
        }
        if (this.isLowerBound()) {
            if (this.targetValue) {
                return this.G > Gmax2;
            }
            return this.G > Gmax1;
        }
        return false;
    }

    protected boolean isUpperBound() {
        return this.alphaStatus == Status.UPPER_BOUND;
    }

    boolean isLowerBound() {
        return this.alphaStatus == Status.LOWER_BOUND;
    }

    public boolean isShrinkable(double Gmax1, double Gmax2, double Gmax3, double Gmax4) {
        if (this.isUpperBound()) {
            if (this.targetValue) {
                return -this.G > Gmax1;
            }
            return -this.G > Gmax4;
        }
        if (this.isLowerBound()) {
            if (this.targetValue) {
                return this.G > Gmax2;
            }
            return this.G > Gmax3;
        }
        return false;
    }

    public void updateAlphaStatus(float Cp, float Cn) {
        this.alphaStatus = this.alpha >= (double)this.getC(Cp, Cn) ? Status.UPPER_BOUND : (this.alpha <= 0.0 ? Status.LOWER_BOUND : Status.FREE);
    }

    float getC(float Cp, float Cn) {
        return this.targetValue ? Cp : Cn;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        LOWER_BOUND,
        UPPER_BOUND,
        FREE;

    }
}

