/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.jlibsvm;

import edu.berkeley.compbio.jlibsvm.SolutionVector;
import edu.berkeley.compbio.jlibsvm.Solver;
import edu.berkeley.compbio.jlibsvm.binary.AlphaModel;
import edu.berkeley.compbio.jlibsvm.binary.BinaryModel;
import edu.berkeley.compbio.jlibsvm.qmatrix.QMatrix;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Solver_NU<L extends Comparable, P>
extends Solver<L, P> {
    protected Solver_NU(QMatrix<P> Q, float Cp, float Cn, float eps, boolean shrinking) {
        super(Q, Cp, Cn, eps, shrinking);
    }

    public Solver_NU(List<SolutionVector<P>> solutionVectors, QMatrix<P> Q, float Cp, float Cn, float eps, boolean shrinking) {
        super(solutionVectors, Q, Cp, Cn, eps, shrinking);
    }

    @Override
    protected void calculate_rho(AlphaModel<L, P> model) {
        int nr_free1 = 0;
        int nr_free2 = 0;
        double ub1 = Double.POSITIVE_INFINITY;
        double ub2 = Double.POSITIVE_INFINITY;
        double lb1 = Double.NEGATIVE_INFINITY;
        double lb2 = Double.NEGATIVE_INFINITY;
        double sum_free1 = 0.0;
        double sum_free2 = 0.0;
        for (SolutionVector sv : this.allExamples) {
            if (sv.targetValue) {
                if (sv.isLowerBound()) {
                    ub1 = Math.min(ub1, sv.G);
                    continue;
                }
                if (sv.isUpperBound()) {
                    lb1 = Math.max(lb1, sv.G);
                    continue;
                }
                ++nr_free1;
                sum_free1 += sv.G;
                continue;
            }
            if (sv.isLowerBound()) {
                ub2 = Math.min(ub2, sv.G);
                continue;
            }
            if (sv.isUpperBound()) {
                lb2 = Math.max(lb2, sv.G);
                continue;
            }
            ++nr_free2;
            sum_free2 += sv.G;
        }
        double r1 = nr_free1 > 0 ? sum_free1 / (double)nr_free1 : (ub1 + lb1) / 2.0;
        double r2 = nr_free2 > 0 ? sum_free2 / (double)nr_free2 : (ub2 + lb2) / 2.0;
        ((BinaryModel)model).r = (float)((r1 + r2) / 2.0);
        model.rho = (float)((r1 - r2) / 2.0);
    }

    @Override
    void do_shrinking() {
        double Gmax1 = Double.NEGATIVE_INFINITY;
        double Gmax2 = Double.NEGATIVE_INFINITY;
        double Gmax3 = Double.NEGATIVE_INFINITY;
        double Gmax4 = Double.NEGATIVE_INFINITY;
        for (SolutionVector sv : this.active) {
            if (!sv.isUpperBound()) {
                if (sv.targetValue) {
                    if (-sv.G > Gmax1) {
                        Gmax1 = -sv.G;
                    }
                } else if (-sv.G > Gmax4) {
                    Gmax4 = -sv.G;
                }
            }
            if (sv.isLowerBound()) continue;
            if (sv.targetValue) {
                if (!(sv.G > Gmax2)) continue;
                Gmax2 = sv.G;
                continue;
            }
            if (!(sv.G > Gmax3)) continue;
            Gmax3 = sv.G;
        }
        if (!this.unshrink && Math.max(Gmax1 + Gmax2, Gmax3 + Gmax4) <= (double)(this.eps * 10.0f)) {
            this.unshrink = true;
            this.reconstruct_gradient();
            this.resetActiveSet();
        }
        ArrayList<SolutionVector> activeList = new ArrayList<SolutionVector>(Arrays.asList(this.active));
        ArrayList<SolutionVector> inactiveList = new ArrayList<SolutionVector>();
        Iterator iter = activeList.iterator();
        while (iter.hasNext()) {
            SolutionVector sv;
            sv = (SolutionVector)iter.next();
            if (!sv.isShrinkable(Gmax1, Gmax2, Gmax3, Gmax4)) continue;
            iter.remove();
            inactiveList.add(sv);
        }
        this.active = activeList.toArray(EMPTY_SV_ARRAY);
        SolutionVector[] newlyInactive = inactiveList.toArray(EMPTY_SV_ARRAY);
        this.Q.maintainCache(this.active, newlyInactive);
        inactiveList.addAll(Arrays.asList(this.inactive));
        this.inactive = inactiveList.toArray(EMPTY_SV_ARRAY);
    }

    @Override
    protected Solver.SolutionVectorPair selectWorkingPair() {
        double Gmaxp = Double.NEGATIVE_INFINITY;
        double Gmaxp2 = Double.NEGATIVE_INFINITY;
        double Gmaxn = Double.NEGATIVE_INFINITY;
        double Gmaxn2 = Double.NEGATIVE_INFINITY;
        SolutionVector GmaxnSV = null;
        SolutionVector GmaxpSV = null;
        SolutionVector GminSV = null;
        double obj_diff_min = Double.POSITIVE_INFINITY;
        for (SolutionVector sv : this.active) {
            if (sv.targetValue) {
                if (sv.isUpperBound() || !(-sv.G >= Gmaxp)) continue;
                Gmaxp = -sv.G;
                GmaxpSV = sv;
                continue;
            }
            if (sv.isLowerBound() || !(sv.G >= Gmaxn)) continue;
            Gmaxn = sv.G;
            GmaxnSV = sv;
        }
        this.Q.getQ(GmaxpSV, this.active, this.Q_svA);
        this.Q.getQ(GmaxnSV, this.active, this.Q_svB);
        for (SolutionVector sv : this.active) {
            double quad_coef;
            double obj_diff;
            double grad_diff;
            if (sv.targetValue) {
                if (sv.isLowerBound()) continue;
                grad_diff = Gmaxp + sv.G;
                if (sv.G >= Gmaxp2) {
                    Gmaxp2 = sv.G;
                }
                if (!(grad_diff > 0.0) || !((obj_diff = (quad_coef = (double)(this.Q.evaluateDiagonal(GmaxpSV) + this.Q.evaluateDiagonal(sv) - 2.0f * this.Q_svA[sv.rank])) > 0.0 ? -(grad_diff * grad_diff) / quad_coef : -(grad_diff * grad_diff) / (double)1.0E-12f) <= obj_diff_min)) continue;
                GminSV = sv;
                obj_diff_min = obj_diff;
                continue;
            }
            if (sv.isUpperBound()) continue;
            grad_diff = Gmaxn - sv.G;
            if (-sv.G >= Gmaxn2) {
                Gmaxn2 = -sv.G;
            }
            if (!(grad_diff > 0.0) || !((obj_diff = (quad_coef = (double)(this.Q.evaluateDiagonal(GmaxnSV) + this.Q.evaluateDiagonal(sv) - 2.0f * this.Q_svB[sv.rank])) > 0.0 ? -(grad_diff * grad_diff) / quad_coef : -(grad_diff * grad_diff) / (double)1.0E-12f) <= obj_diff_min)) continue;
            GminSV = sv;
            obj_diff_min = obj_diff;
        }
        return new Solver.SolutionVectorPair(this, GminSV.targetValue ? GmaxpSV : GmaxnSV, GminSV, Math.max(Gmaxp + Gmaxp2, Gmaxn + Gmaxn2) < (double)this.eps);
    }
}

