/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.jlibsvm.binary;

import edu.berkeley.compbio.jlibsvm.SolutionModel;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AlphaModel<L extends Comparable, P>
extends SolutionModel<L, P> {
    public Map<P, Double> supportVectors;
    public int numSVs;
    public P[] SVs;
    public double[] alphas;
    public float rho;

    protected AlphaModel() {
    }

    public void compact() {
        Iterator<Map.Entry<P, Double>> i = this.supportVectors.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<P, Double> entry = i.next();
            if (entry.getValue() != 0.0) continue;
            i.remove();
        }
        this.numSVs = this.supportVectors.size();
        this.SVs = new Object[this.numSVs];
        this.alphas = new double[this.numSVs];
        int c = 0;
        for (Map.Entry<P, Double> entry : this.supportVectors.entrySet()) {
            this.SVs[c] = entry.getKey();
            this.alphas[c] = entry.getValue();
            ++c;
        }
        this.supportVectors = null;
    }

    @Override
    protected void readSupportVectors(BufferedReader reader) throws IOException {
        throw new NotImplementedException();
    }

    protected void writeSupportVectors(DataOutputStream fp) throws IOException {
        fp.writeBytes("SV\n");
        for (int i = 0; i < this.numSVs; ++i) {
            fp.writeBytes(this.alphas[i] + " ");
            fp.writeBytes(this.SVs[i].toString());
            fp.writeBytes("\n");
        }
    }

    @Override
    public void writeToStream(DataOutputStream fp) throws IOException {
        super.writeToStream(fp);
        fp.writeBytes("rho " + this.rho + "\n");
        fp.writeBytes("total_sv " + this.numSVs + "\n");
    }
}

