/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.jlibsvm.binary;

import edu.berkeley.compbio.jlibsvm.ExplicitSvmProblemImpl;
import edu.berkeley.compbio.jlibsvm.binary.BinaryClassificationProblem;
import edu.berkeley.compbio.jlibsvm.scaler.ScalingModel;
import edu.berkeley.compbio.jlibsvm.scaler.ScalingModelLearner;
import edu.berkeley.compbio.jlibsvm.util.SubtractionMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryClassificationProblemImpl<L extends Comparable, P>
extends ExplicitSvmProblemImpl<L, P, BinaryClassificationProblem<L, P>>
implements BinaryClassificationProblem<L, P> {
    Class labelClass;
    L trueLabel;
    L falseLabel;
    private ScalingModelLearner<P> lastScalingModelLearner = null;
    private BinaryClassificationProblem<L, P> scaledCopy = null;

    public BinaryClassificationProblemImpl(Class labelClass, Map<P, L> examples, @NotNull Map<P, Integer> exampleIds) {
        super(examples, exampleIds);
        this.setupLabels();
        this.labelClass = labelClass;
    }

    @Override
    public void setupLabels() {
        List result = super.getLabels();
        if (result != null) {
            this.falseLabel = (Comparable)result.get(1);
            this.trueLabel = (Comparable)result.get(0);
        }
    }

    public BinaryClassificationProblemImpl(Class labelClass, Map<P, L> examples, Map<P, Integer> exampleIds, ScalingModel<P> scalingModel, L trueLabel, L falseLabel) {
        super(examples, exampleIds, scalingModel);
        this.trueLabel = trueLabel;
        this.falseLabel = falseLabel;
        this.labelClass = labelClass;
    }

    public BinaryClassificationProblemImpl(BinaryClassificationProblemImpl<L, P> backingProblem, Set<P> heldOutPoints) {
        super(new SubtractionMap(backingProblem.examples, heldOutPoints), backingProblem.exampleIds, backingProblem.scalingModel, heldOutPoints);
        this.trueLabel = backingProblem.trueLabel;
        this.falseLabel = backingProblem.falseLabel;
        this.labelClass = backingProblem.labelClass;
    }

    @Override
    public L getFalseLabel() {
        return this.falseLabel;
    }

    @Override
    public L getTrueLabel() {
        return this.trueLabel;
    }

    @Override
    public Map<P, Boolean> getBooleanExamples() {
        this.setupLabels();
        HashMap result = new HashMap(this.examples.size());
        for (Map.Entry entry : this.examples.entrySet()) {
            result.put(entry.getKey(), ((Comparable)entry.getValue()).equals(this.trueLabel) ? Boolean.TRUE : Boolean.FALSE);
        }
        return result;
    }

    @Override
    public BinaryClassificationProblem<L, P> getScaledCopy(@NotNull ScalingModelLearner<P> scalingModelLearner) {
        if (!scalingModelLearner.equals(this.lastScalingModelLearner)) {
            this.scaledCopy = (BinaryClassificationProblem)this.learnScaling(scalingModelLearner);
            this.lastScalingModelLearner = scalingModelLearner;
        }
        return this.scaledCopy;
    }

    @Override
    public BinaryClassificationProblem<L, P> createScaledCopy(Map<P, L> scaledExamples, Map<P, Integer> scaledExampleIds, ScalingModel<P> learnedScalingModel) {
        return new BinaryClassificationProblemImpl<L, P>(this.labelClass, scaledExamples, scaledExampleIds, learnedScalingModel, this.trueLabel, this.falseLabel);
    }

    @Override
    public L getTargetValue(P point2) {
        return (L)((Comparable)this.examples.get(point2));
    }

    @Override
    protected BinaryClassificationProblem<L, P> makeFold(Set<P> heldOutPoints) {
        return new BinaryClassificationProblemImpl<L, P>(this, heldOutPoints);
    }
}

