/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.jlibsvm.binary;

import edu.berkeley.compbio.jlibsvm.SolutionVector;
import edu.berkeley.compbio.jlibsvm.Solver;
import edu.berkeley.compbio.jlibsvm.binary.BinaryModel;
import edu.berkeley.compbio.jlibsvm.qmatrix.QMatrix;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinarySolver<L extends Comparable, P>
extends Solver<L, P> {
    public BinarySolver(List<SolutionVector<P>> solutionVectors, QMatrix<P> Q, float Cp, float Cn, float eps, boolean shrinking) {
        super(solutionVectors, Q, Cp, Cn, eps, shrinking);
    }

    public BinaryModel<L, P> solve() {
        this.optimize();
        BinaryModel model = new BinaryModel();
        this.calculate_rho(model);
        float v = 0.0f;
        for (SolutionVector svC : this.allExamples) {
            v = (float)((double)v + svC.alpha * (svC.G + (double)svC.linearTerm));
        }
        model.obj = v / 2.0f;
        model.supportVectors = new HashMap();
        for (SolutionVector svC : this.allExamples) {
            model.supportVectors.put(svC.point, svC.alpha);
        }
        model.upperBoundPositive = this.Cp;
        model.upperBoundNegative = this.Cn;
        return model;
    }
}

