/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.jlibsvm.binary;

import com.davidsoergel.dsutils.collections.MappingIterator;
import com.google.common.collect.HashMultiset;
import edu.berkeley.compbio.jlibsvm.binary.BinaryClassificationProblem;
import edu.berkeley.compbio.jlibsvm.binary.BinaryClassificationProblemImpl;
import edu.berkeley.compbio.jlibsvm.scaler.ScalingModelLearner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanClassificationProblemImpl<L extends Comparable, P>
extends BinaryClassificationProblemImpl<L, P> {
    private Map<P, Boolean> booleanExamples;
    private Set<P> trueExamples;
    private Set<P> falseExamples;
    int numExamples = 0;

    public BooleanClassificationProblemImpl(Class labelClass, L trueLabel, Set<P> trueExamples, L falseLabel, Set<P> falseExamples, Map<P, Integer> exampleIds) {
        super(labelClass, null, exampleIds);
        this.falseLabel = falseLabel;
        this.trueLabel = trueLabel;
        this.trueExamples = trueExamples;
        this.falseExamples = falseExamples;
        this.labels = new ArrayList(2);
        this.labels.add(trueLabel);
        this.labels.add(falseLabel);
        this.numExamples = trueExamples.size() + falseExamples.size();
        this.exampleCounts = HashMultiset.create();
        this.exampleCounts.add(trueLabel, trueExamples.size());
        this.exampleCounts.add(falseLabel, falseExamples.size());
    }

    public BooleanClassificationProblemImpl(BooleanClassificationProblemImpl<L, P> backingProblem, Set<P> heldOutPoints) {
        super(backingProblem.labelClass, null, backingProblem.exampleIds, backingProblem.scalingModel, backingProblem.trueLabel, backingProblem.falseLabel);
        this.heldOutPoints = heldOutPoints;
        this.trueExamples = new HashSet<P>(backingProblem.trueExamples);
        this.falseExamples = new HashSet<P>(backingProblem.falseExamples);
        this.trueExamples.removeAll(heldOutPoints);
        this.falseExamples.removeAll(heldOutPoints);
        this.labels = new ArrayList(2);
        this.labels.add(this.trueLabel);
        this.labels.add(this.falseLabel);
        this.numExamples = this.trueExamples.size() + this.falseExamples.size();
        this.exampleCounts = HashMultiset.create();
        this.exampleCounts.add(this.trueLabel, this.trueExamples.size());
        this.exampleCounts.add(this.falseLabel, this.falseExamples.size());
    }

    @Override
    public synchronized Map<P, Boolean> getBooleanExamples() {
        if (this.booleanExamples == null) {
            this.booleanExamples = new HashMap<P, Boolean>(this.numExamples);
            for (P trueExample : this.trueExamples) {
                this.booleanExamples.put(trueExample, Boolean.TRUE);
            }
            for (P falseExample : this.falseExamples) {
                this.booleanExamples.put(falseExample, Boolean.FALSE);
            }
            assert (this.booleanExamples.size() == this.numExamples);
        }
        return this.booleanExamples;
    }

    @Override
    public BinaryClassificationProblem<L, P> getScaledCopy(@NotNull ScalingModelLearner<P> scalingModelLearner) {
        return this;
    }

    @Override
    public void setupLabels() {
    }

    @Override
    public synchronized L getTargetValue(P point2) {
        if (this.booleanExamples.get(point2).booleanValue()) {
            return (L)this.trueLabel;
        }
        return (L)this.falseLabel;
    }

    @Override
    public int getNumExamples() {
        return this.numExamples;
    }

    @Override
    public Iterator<BinaryClassificationProblem<L, P>> makeFolds(int numberOfFolds) {
        ArrayList<P> points = new ArrayList<P>(this.getBooleanExamples().keySet());
        Collections.shuffle(points);
        ArrayList heldOutPointSets = new ArrayList();
        for (int i = 0; i < numberOfFolds; ++i) {
            heldOutPointSets.add(new HashSet());
        }
        int f = 0;
        for (Object point2 : points) {
            ((Set)heldOutPointSets.get(f)).add(point2);
            ++f;
            f %= numberOfFolds;
        }
        MappingIterator foldIterator = new MappingIterator<Set<P>, BinaryClassificationProblem<L, P>>(heldOutPointSets.iterator()){

            @Override
            public BinaryClassificationProblem<L, P> function(Set<P> p) {
                return BooleanClassificationProblemImpl.this.makeFold(p);
            }
        };
        return foldIterator;
    }

    @Override
    protected BooleanClassificationProblemImpl<L, P> makeFold(Set<P> heldOutPoints) {
        return new BooleanClassificationProblemImpl<L, P>(this, heldOutPoints);
    }
}

