/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.jlibsvm.binary;

import edu.berkeley.compbio.jlibsvm.SigmoidProbabilityModel;
import edu.berkeley.compbio.jlibsvm.binary.BinaryClassificationProblem;
import edu.berkeley.compbio.ml.BinaryCrossValidationResults;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvmBinaryCrossValidationResults<L extends Comparable, P>
extends BinaryCrossValidationResults {
    private static final Logger logger = Logger.getLogger(SvmBinaryCrossValidationResults.class);
    SigmoidProbabilityModel sigmoid;

    public SvmBinaryCrossValidationResults(BinaryClassificationProblem<L, P> problem, Map<P, Float> decisionValues, boolean probability) {
        int totalExamples = decisionValues.size();
        float[] decisionValueArray = new float[totalExamples];
        boolean[] labelArray = new boolean[totalExamples];
        logger.debug("Collecting binary cross-validation results for " + totalExamples + " points");
        L trueLabel = problem.getTrueLabel();
        for (Map.Entry<P, Float> entry : decisionValues.entrySet()) {
            decisionValueArray[this.numExamples] = entry.getValue().floatValue();
            labelArray[this.numExamples] = problem.getTargetValue(entry.getKey()).equals(trueLabel);
            ++this.numExamples;
        }
        if (probability) {
            this.sigmoid = new SigmoidProbabilityModel(decisionValueArray, labelArray);
        }
        for (int j = 0; j < this.numExamples; ++j) {
            if (decisionValueArray[j] > 0.0f) {
                if (labelArray[j]) {
                    ++this.tt;
                    continue;
                }
                ++this.ft;
                continue;
            }
            if (labelArray[j]) {
                ++this.tf;
                continue;
            }
            ++this.ff;
        }
    }

    public SigmoidProbabilityModel getSigmoid() {
        return this.sigmoid;
    }
}

