/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.jlibsvm.kernel;

import edu.berkeley.compbio.jlibsvm.kernel.GammaKernel;
import edu.berkeley.compbio.jlibsvm.kernel.KernelFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeGaussianRBFKernel<T>
extends GammaKernel<T> {
    KernelFunction<T> underlyingKernel;

    public CompositeGaussianRBFKernel(double gamma, KernelFunction<T> underlyingKernel) {
        super(gamma);
        this.underlyingKernel = underlyingKernel;
    }

    @Override
    public double evaluate(T x, T y) {
        double xSquare = this.underlyingKernel.evaluate(x, x);
        double ySquare = this.underlyingKernel.evaluate(y, y);
        double differenceNormSquared = xSquare + ySquare - 2.0 * this.underlyingKernel.evaluate(x, y);
        double result = Math.exp(-this.gamma * differenceNormSquared);
        return result;
    }
}

