/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.jlibsvm.legacyexec;

import edu.berkeley.compbio.jlibsvm.ContinuousModel;
import edu.berkeley.compbio.jlibsvm.DiscreteModel;
import edu.berkeley.compbio.jlibsvm.SolutionModel;
import edu.berkeley.compbio.jlibsvm.SvmException;
import edu.berkeley.compbio.jlibsvm.multi.MultiClassModel;
import edu.berkeley.compbio.jlibsvm.regression.RegressionModel;
import edu.berkeley.compbio.jlibsvm.util.SparseVector;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class svm_predict {
    public static void main(String[] argv) throws IOException {
        int i;
        int predict_probability = 0;
        block6: for (i = 0; i < argv.length && argv[i].charAt(0) == '-'; ++i) {
            switch (argv[++i - 1].charAt(1)) {
                case 'b': {
                    predict_probability = Integer.parseInt(argv[i]);
                    continue block6;
                }
                default: {
                    System.err.print("Unknown option: " + argv[i - 1] + "\n");
                    svm_predict.exit_with_help();
                }
            }
        }
        if (i >= argv.length) {
            svm_predict.exit_with_help();
        }
        try {
            BufferedReader input = new BufferedReader(new FileReader(argv[i]));
            DataOutputStream output = new DataOutputStream(new FileOutputStream(argv[i + 2]));
            SolutionModel model = SolutionModel.identifyTypeAndLoad(argv[i + 1]);
            if (predict_probability == 1) {
                if (model instanceof MultiClassModel) {
                    if (!((MultiClassModel)model).supportsOneVsOneProbability()) {
                        System.err.print("Model does not support probability estimates\n");
                        System.exit(1);
                    }
                } else if (model instanceof RegressionModel) {
                    if (!((RegressionModel)model).supportsLaplace()) {
                        System.err.print("Model does not support probability estimates\n");
                        System.exit(1);
                    }
                } else {
                    System.err.print("Model does not support probability estimates\n");
                    System.exit(1);
                }
            } else if (model instanceof MultiClassModel && ((MultiClassModel)model).supportsOneVsOneProbability()) {
                System.out.print("Model supports probability estimates, but disabled in prediction.\n");
            } else if (model instanceof RegressionModel && ((RegressionModel)model).supportsLaplace()) {
                System.out.print("Model supports Laplace parameter estimation, but disabled in prediction.\n");
            }
            svm_predict.predict(input, output, model, predict_probability);
            input.close();
            output.close();
        }
        catch (FileNotFoundException e) {
            svm_predict.exit_with_help();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            svm_predict.exit_with_help();
        }
    }

    private static void predict(BufferedReader input, DataOutputStream output, SolutionModel model, int predict_probability) throws IOException {
        String line;
        int correct = 0;
        int total = 0;
        double error = 0.0;
        double sumv = 0.0;
        double sumy = 0.0;
        double sumvv = 0.0;
        double sumyy = 0.0;
        double sumvy = 0.0;
        if (predict_probability == 1) {
            if (model instanceof RegressionModel) {
                System.out.print("Prob. model for test data: target value = predicted value + z,\nz: Laplace distribution e^(-|z|/sigma)/(2sigma),sigma=" + ((RegressionModel)model).laplaceParameter + "\n");
            } else {
                output.writeBytes("labels");
                for (Object i : model.getLabels()) {
                    output.writeBytes(" " + i);
                }
                output.writeBytes("\n");
            }
        }
        while ((line = input.readLine()) != null) {
            Float prediction;
            StringTokenizer st = new StringTokenizer(line, " \t\n\r\f:");
            Float target = Float.valueOf(Float.parseFloat(st.nextToken()));
            int m = st.countTokens() / 2;
            SparseVector x = new SparseVector(m);
            for (int j = 0; j < m; ++j) {
                x.indexes[j] = Integer.parseInt(st.nextToken());
                x.values[j] = Float.parseFloat(st.nextToken());
            }
            if (predict_probability == 1 && model instanceof MultiClassModel) {
                Map prob_estimates = ((MultiClassModel)model).predictProbability(x);
                prediction = ((MultiClassModel)model).bestProbabilityLabel(prob_estimates);
                output.writeBytes(prediction + " ");
                TreeMap prob_estimates_sorted = new TreeMap(prob_estimates);
                Iterator i$ = prob_estimates_sorted.values().iterator();
                while (i$.hasNext()) {
                    float prob_estimate = ((Float)i$.next()).floatValue();
                    output.writeBytes(prob_estimate + " ");
                }
                output.writeBytes("\n");
            } else if (predict_probability == 1 && model instanceof RegressionModel) {
                prediction = ((RegressionModel)model).predictValue(x);
                output.writeBytes(prediction + " " + ((RegressionModel)model).laplaceParameter);
            } else if (model instanceof DiscreteModel) {
                prediction = ((DiscreteModel)((Object)model)).predictLabel(x);
                output.writeBytes(prediction + "\n");
            } else if (model instanceof ContinuousModel) {
                prediction = ((ContinuousModel)((Object)model)).predictValue(x);
                output.writeBytes(prediction + "\n");
            } else {
                throw new SvmException("Don't know how to predict using model: " + model.getClass());
            }
            if (((Object)prediction).equals(target)) {
                ++correct;
            }
            if (prediction instanceof Float) {
                Float v = prediction;
                error += (double)((v.floatValue() - target.floatValue()) * (v.floatValue() - target.floatValue()));
                sumv += (double)v.floatValue();
                sumy += (double)target.floatValue();
                sumvv += (double)(v.floatValue() * v.floatValue());
                sumyy += (double)(target.floatValue() * target.floatValue());
                sumvy += (double)(v.floatValue() * target.floatValue());
            }
            ++total;
        }
        if (model instanceof RegressionModel) {
            System.out.print("Mean squared error = " + error / (double)total + " (regression)\n");
            System.out.print("Squared correlation coefficient = " + ((double)total * sumvy - sumv * sumy) * ((double)total * sumvy - sumv * sumy) / (((double)total * sumvv - sumv * sumv) * ((double)total * sumyy - sumy * sumy)) + " (regression)\n");
        } else {
            System.out.print("Accuracy = " + (double)correct / (double)total * 100.0 + "% (" + correct + "/" + total + ") (classification)\n");
        }
    }

    private static void exit_with_help() {
        System.err.print("usage: svm_predict [options] test_file model_file output_file\noptions:\n-b probability_estimates: whether to predict probability estimates, 0 or 1 (default 0); one-class SVM not supported yet\n");
        System.exit(1);
    }
}

