/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.jlibsvm.legacyexec;

import com.davidsoergel.conja.Parallel;
import edu.berkeley.compbio.jlibsvm.ImmutableSvmParameter;
import edu.berkeley.compbio.jlibsvm.ImmutableSvmParameterGrid;
import edu.berkeley.compbio.jlibsvm.ImmutableSvmParameterPoint;
import edu.berkeley.compbio.jlibsvm.MutableSvmProblem;
import edu.berkeley.compbio.jlibsvm.SVM;
import edu.berkeley.compbio.jlibsvm.SolutionModel;
import edu.berkeley.compbio.jlibsvm.SvmException;
import edu.berkeley.compbio.jlibsvm.binary.BinaryClassificationProblem;
import edu.berkeley.compbio.jlibsvm.binary.BinaryClassificationSVM;
import edu.berkeley.compbio.jlibsvm.binary.C_SVC;
import edu.berkeley.compbio.jlibsvm.binary.MutableBinaryClassificationProblemImpl;
import edu.berkeley.compbio.jlibsvm.binary.Nu_SVC;
import edu.berkeley.compbio.jlibsvm.kernel.GammaKernel;
import edu.berkeley.compbio.jlibsvm.kernel.GaussianRBFKernel;
import edu.berkeley.compbio.jlibsvm.kernel.KernelFunction;
import edu.berkeley.compbio.jlibsvm.kernel.LinearKernel;
import edu.berkeley.compbio.jlibsvm.kernel.PolynomialKernel;
import edu.berkeley.compbio.jlibsvm.kernel.PrecomputedKernel;
import edu.berkeley.compbio.jlibsvm.kernel.SigmoidKernel;
import edu.berkeley.compbio.jlibsvm.labelinverter.StringLabelInverter;
import edu.berkeley.compbio.jlibsvm.multi.MultiClassModel;
import edu.berkeley.compbio.jlibsvm.multi.MultiClassificationSVM;
import edu.berkeley.compbio.jlibsvm.multi.MutableMultiClassProblemImpl;
import edu.berkeley.compbio.jlibsvm.oneclass.OneClassSVC;
import edu.berkeley.compbio.jlibsvm.regression.EpsilonSVR;
import edu.berkeley.compbio.jlibsvm.regression.MutableRegressionProblemImpl;
import edu.berkeley.compbio.jlibsvm.regression.Nu_SVR;
import edu.berkeley.compbio.jlibsvm.regression.RegressionSVM;
import edu.berkeley.compbio.jlibsvm.scaler.LinearScalingModelLearner;
import edu.berkeley.compbio.jlibsvm.scaler.NoopScalingModel;
import edu.berkeley.compbio.jlibsvm.scaler.NoopScalingModelLearner;
import edu.berkeley.compbio.jlibsvm.scaler.ScalingModelLearner;
import edu.berkeley.compbio.jlibsvm.scaler.ZscoreScalingModelLearner;
import edu.berkeley.compbio.jlibsvm.util.SparseVector;
import edu.berkeley.compbio.ml.CrossValidationResults;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class svm_train {
    static final int C_SVC = 0;
    static final int NU_SVC = 1;
    static final int ONE_CLASS = 2;
    static final int EPSILON_SVR = 3;
    static final int NU_SVR = 4;
    static final int LINEAR = 0;
    static final int POLY = 1;
    static final int RBF = 2;
    static final int SIGMOID = 3;
    static final int PRECOMPUTED = 4;
    SVM svm;
    ImmutableSvmParameter param;
    private MutableSvmProblem problem;
    private SolutionModel model;
    private String input_file_name;
    private String model_file_name;
    private boolean crossValidation;
    private static final Float UNSPECIFIED_GAMMA = Float.valueOf(-1.0f);

    public static void main(String[] argv) throws IOException {
        svm_train t = new svm_train();
        t.run(argv);
    }

    private void run(String[] argv) throws IOException {
        this.parse_command_line(argv);
        this.read_problem();
        long startTime = System.currentTimeMillis();
        if (this.svm instanceof BinaryClassificationSVM && this.problem.getLabels().size() > 2) {
            this.svm = new MultiClassificationSVM((BinaryClassificationSVM)this.svm);
        }
        this.model = this.svm.train(this.problem, this.param);
        CrossValidationResults cv = this.model.getCrossValidationResults();
        if (cv == null && this.crossValidation) {
            cv = this.svm.performCrossValidation(this.problem, this.param);
        }
        if (cv != null) {
            System.out.println(cv.toString());
        }
        long endTime = System.currentTimeMillis();
        float time = (float)(endTime - startTime) / 1000.0f;
        System.out.println("Finished in " + time + " secs");
        Parallel.shutdown();
    }

    private void parse_command_line(String[] argv) {
        int i;
        ImmutableSvmParameterGrid.Builder builder = ImmutableSvmParameterGrid.builder();
        builder.nu = 0.5f;
        builder.cache_size = 100.0f;
        builder.eps = 0.001f;
        builder.p = 0.1f;
        builder.shrinking = true;
        builder.probability = false;
        builder.redistributeUnbalancedC = true;
        ScalingModelLearner scalingModelLearner = new NoopScalingModelLearner();
        String scalingType = null;
        int scalingExamples = 1000;
        boolean normalizeL2 = false;
        int svm_type = 0;
        int kernel_type = 2;
        int degree = 3;
        HashSet<Float> gammaSet = new HashSet<Float>();
        float coef0 = 0.0f;
        block41: for (i = 0; i < argv.length && argv[i].charAt(0) == '-'; ++i) {
            if (++i >= argv.length) {
                svm_train.exit_with_help();
            }
            switch (argv[i - 1].charAt(1)) {
                case 's': {
                    svm_type = Integer.parseInt(argv[i]);
                    continue block41;
                }
                case 't': {
                    kernel_type = Integer.parseInt(argv[i]);
                    continue block41;
                }
                case 'd': {
                    degree = Integer.parseInt(argv[i]);
                    continue block41;
                }
                case 'g': {
                    gammaSet = new HashSet();
                    for (String s : argv[i].split(",")) {
                        gammaSet.add(Float.valueOf(Float.parseFloat(s)));
                    }
                    continue block41;
                }
                case 'r': {
                    coef0 = Float.parseFloat(argv[i]);
                    continue block41;
                }
                case 'n': {
                    builder.nu = Float.parseFloat(argv[i]);
                    continue block41;
                }
                case 'm': {
                    builder.cache_size = Float.parseFloat(argv[i]);
                    continue block41;
                }
                case 'c': {
                    builder.Cset = new HashSet<Float>();
                    for (String s : argv[i].split(",")) {
                        builder.Cset.add(Float.valueOf(Float.parseFloat(s)));
                    }
                    continue block41;
                }
                case 'e': {
                    builder.eps = Float.parseFloat(argv[i]);
                    continue block41;
                }
                case 'p': {
                    builder.p = Float.parseFloat(argv[i]);
                    continue block41;
                }
                case 'h': {
                    builder.shrinking = argv[i].equals("1") || Boolean.parseBoolean(argv[i]);
                    continue block41;
                }
                case 'b': {
                    builder.probability = argv[i].equals("1") || Boolean.parseBoolean(argv[i]);
                    continue block41;
                }
                case 'u': {
                    builder.redistributeUnbalancedC = argv[i].equals("1") || Boolean.parseBoolean(argv[i]);
                    continue block41;
                }
                case 'v': {
                    builder.crossValidationFolds = Integer.parseInt(argv[i]);
                    if (builder.crossValidationFolds >= 2) continue block41;
                    System.err.print("n-fold cross validation: n must >= 2\n");
                    svm_train.exit_with_help();
                    continue block41;
                }
                case 'q': {
                    this.crossValidation = argv[i].equals("1") || Boolean.parseBoolean(argv[i]);
                    continue block41;
                }
                case 'w': {
                    builder.putWeight(Integer.parseInt(argv[i - 1].substring(2)), Float.valueOf(Float.parseFloat(argv[i])));
                    continue block41;
                }
                case 'a': {
                    builder.allVsAllMode = MultiClassModel.AllVsAllMode.valueOf(argv[i]);
                    continue block41;
                }
                case 'o': {
                    builder.oneVsAllMode = MultiClassModel.OneVsAllMode.valueOf(argv[i]);
                    continue block41;
                }
                case 'k': {
                    builder.oneVsAllThreshold = Double.parseDouble(argv[i]);
                    continue block41;
                }
                case 'j': {
                    builder.minVoteProportion = Double.parseDouble(argv[i]);
                    continue block41;
                }
                case 'f': {
                    scalingType = argv[i];
                    continue block41;
                }
                case 'x': {
                    scalingExamples = Integer.parseInt(argv[i]);
                    continue block41;
                }
                case 'l': {
                    int normalizeDim = Integer.parseInt(argv[i]);
                    if (normalizeDim == 2) {
                        normalizeL2 = true;
                        continue block41;
                    }
                    System.err.print("-l must == 2\n");
                    svm_train.exit_with_help();
                    continue block41;
                }
                case 'y': {
                    builder.gridsearchBinaryMachinesIndependently = argv[i].equals("1") || Boolean.parseBoolean(argv[i]);
                    continue block41;
                }
                case 'z': {
                    builder.scaleBinaryMachinesIndependently = argv[i].equals("1") || Boolean.parseBoolean(argv[i]);
                    continue block41;
                }
                default: {
                    System.err.print("Unknown option: " + argv[i - 1] + "\n");
                    svm_train.exit_with_help();
                }
            }
        }
        if (scalingType != null) {
            if (scalingType.equals("linear")) {
                scalingModelLearner = new LinearScalingModelLearner(scalingExamples, normalizeL2);
            } else if (scalingType.equals("zscore")) {
                scalingModelLearner = new ZscoreScalingModelLearner(scalingExamples, normalizeL2);
            }
        }
        if (i >= argv.length) {
            svm_train.exit_with_help();
        }
        this.input_file_name = argv[i];
        if (i < argv.length - 1) {
            this.model_file_name = argv[i + 1];
        } else {
            int p = argv[i].lastIndexOf(47);
            this.model_file_name = argv[i].substring(++p) + ".model";
        }
        if (gammaSet.isEmpty()) {
            gammaSet.add(UNSPECIFIED_GAMMA);
        }
        builder.kernelSet = new HashSet();
        switch (kernel_type) {
            case 0: {
                builder.kernelSet.add(new LinearKernel());
                break;
            }
            case 1: {
                for (Float gamma : gammaSet) {
                    builder.kernelSet.add(new PolynomialKernel(degree, gamma.floatValue(), coef0));
                }
                break;
            }
            case 2: {
                for (Float gamma : gammaSet) {
                    builder.kernelSet.add(new GaussianRBFKernel(gamma.floatValue()));
                }
                break;
            }
            case 3: {
                for (Float gamma : gammaSet) {
                    builder.kernelSet.add(new SigmoidKernel(gamma.floatValue(), coef0));
                }
                break;
            }
            case 4: {
                builder.kernelSet.add(new PrecomputedKernel());
                break;
            }
            default: {
                throw new SvmException("Unknown kernel type: " + kernel_type);
            }
        }
        builder.scalingModelLearner = scalingModelLearner;
        this.param = builder.build();
        switch (svm_type) {
            case 0: {
                this.svm = new C_SVC();
                break;
            }
            case 1: {
                this.svm = new Nu_SVC();
                break;
            }
            case 2: {
                this.svm = new OneClassSVC();
                break;
            }
            case 3: {
                this.svm = new EpsilonSVR();
                break;
            }
            case 4: {
                this.svm = new Nu_SVR();
                break;
            }
            default: {
                throw new SvmException("Unknown svm type: " + kernel_type);
            }
        }
    }

    private static void exit_with_help() {
        System.out.print("Usage: svm_train [options] training_set_file [model_file]\noptions:\n-s svm_type : set type of SVM (default 0)\n\t0 -- C-SVC\n\t1 -- nu-SVC\n\t2 -- one-class SVM\n\t3 -- epsilon-SVR\n\t4 -- nu-SVR\n-t kernel_type : set type of kernel function (default 2)\n\t0 -- linear: u'*v\n\t1 -- polynomial: (gamma*u'*v + coef0)^degree\n\t2 -- radial basis function: exp(-gamma*|u-v|^2)\n\t3 -- sigmoid: tanh(gamma*u'*v + coef0)\n\t4 -- precomputed kernel (kernel values in training_set_file)\n-d degree : set degree in kernel function (default 3)\n-g gamma : set gamma in kernel function (default 1/k)\n-r coef0 : set coef0 in kernel function (default 0)\n-c cost : set the parameter C of C-SVC, epsilon-SVR, and nu-SVR (default 1)\n-n nu : set the parameter nu of nu-SVC, one-class SVM, and nu-SVR (default 0.5)\n-p epsilon : set the epsilon in loss function of epsilon-SVR (default 0.1)\n-m cachesize : set cache memory size in MB (default 100)\n-e epsilon : set tolerance of termination criterion (default 0.001)\n-h shrinking: whether to use the shrinking heuristics, 0 or 1 (default 1)\n-b probability_estimates: whether to train a SVC or SVR model for probability estimates, 0 or 1 (default 0)\n-wi weight: set the parameter C of class i to weight*C, for C-SVC (default 1)\n-a allVsAllMode: None, AllVsAll, FilteredVsAll, FilteredVsFiltered\n-j minVoteProportion: the chosen class must have at least this proportion of the total votes\n-o oneVsAllMode: None, Best, Veto, BreakTies, VetoAndBreakTies \n-k oneVsAllProb: the chosen class must have at least this one-vs-all probability; if -b is not set, probabilities are 0 or 1\n-v n: n-fold cross validation mode\n-f scalingmode : none (default), linear, zscore\n-x scalinglimit : maximum examples to use for scaling (default 1000)\n-l 2: project to unit sphere (normalize L2 distance)\n");
        System.exit(1);
    }

    private void read_problem() throws IOException {
        HashSet uniqueClasses;
        int numClasses;
        String line;
        BufferedReader fp = new BufferedReader(new FileReader(this.input_file_name));
        Vector<Float> vy = new Vector<Float>();
        Vector<SparseVector> vx = new Vector<SparseVector>();
        int max_index = 0;
        while ((line = fp.readLine()) != null) {
            StringTokenizer st = new StringTokenizer(line, " \t\n\r\f:");
            vy.addElement(Float.valueOf(Float.parseFloat(st.nextToken())));
            int m = st.countTokens() / 2;
            SparseVector x = new SparseVector(m);
            for (int j = 0; j < m; ++j) {
                x.indexes[j] = Integer.parseInt(st.nextToken());
                x.values[j] = Float.parseFloat(st.nextToken());
            }
            if (m > 0) {
                max_index = Math.max(max_index, x.indexes[m - 1]);
            }
            vx.addElement(x);
        }
        this.problem = this.svm instanceof RegressionSVM ? new MutableRegressionProblemImpl(vy.size()) : ((numClasses = (uniqueClasses = new HashSet(vy)).size()) == 1 ? new MutableRegressionProblemImpl(vy.size()) : (numClasses == 2 ? new MutableBinaryClassificationProblemImpl(String.class, vy.size()) : new MutableMultiClassProblemImpl(String.class, new StringLabelInverter(), vy.size(), new NoopScalingModel())));
        for (int i = 0; i < vy.size(); ++i) {
            this.problem.addExampleFloat(vx.elementAt(i), (Float)vy.elementAt(i));
        }
        if (this.problem instanceof BinaryClassificationProblem) {
            ((BinaryClassificationProblem)((Object)this.problem)).setupLabels();
        }
        if (this.param instanceof ImmutableSvmParameterGrid) {
            Collection gridParams = ((ImmutableSvmParameterGrid)this.param).getGridParams();
            for (ImmutableSvmParameterPoint subparam : gridParams) {
                this.updateKernelWithNumExamples(subparam, max_index);
            }
        } else {
            this.updateKernelWithNumExamples((ImmutableSvmParameterPoint)this.param, max_index);
        }
        fp.close();
    }

    private void updateKernelWithNumExamples(ImmutableSvmParameterPoint pointParam, int max_index) {
        KernelFunction kernel = pointParam.kernel;
        if (kernel instanceof GammaKernel && ((GammaKernel)kernel).getGamma() == (double)UNSPECIFIED_GAMMA.floatValue()) {
            ((GammaKernel)kernel).setGamma(1.0f / (float)max_index);
        }
        if (kernel instanceof PrecomputedKernel) {
            throw new NotImplementedException();
        }
    }
}

