/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.jlibsvm.multi;

import edu.berkeley.compbio.jlibsvm.ExplicitSvmProblemImpl;
import edu.berkeley.compbio.jlibsvm.labelinverter.LabelInverter;
import edu.berkeley.compbio.jlibsvm.multi.MultiClassProblem;
import edu.berkeley.compbio.jlibsvm.scaler.ScalingModel;
import edu.berkeley.compbio.jlibsvm.scaler.ScalingModelLearner;
import edu.berkeley.compbio.jlibsvm.util.SubtractionMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiClassProblemImpl<L extends Comparable, P>
extends ExplicitSvmProblemImpl<L, P, MultiClassProblem<L, P>>
implements MultiClassProblem<L, P> {
    Class labelClass;
    private LabelInverter<L> labelInverter;
    private ScalingModelLearner<P> lastScalingModelLearner = null;
    private MultiClassProblem<L, P> scaledCopy = null;
    private Map<L, Set<P>> theInverseMap = null;

    public MultiClassProblemImpl(Class labelClass, LabelInverter<L> labelInverter, Map<P, L> examples, Map<P, Integer> exampleIds, ScalingModel<P> scalingModel) {
        super(examples, exampleIds, scalingModel);
        this.labelClass = labelClass;
        this.labelInverter = labelInverter;
    }

    public MultiClassProblemImpl(MultiClassProblemImpl<L, P> backingProblem, Set<P> heldOutPoints) {
        super(new SubtractionMap(backingProblem.examples, heldOutPoints), backingProblem.exampleIds, backingProblem.scalingModel, heldOutPoints);
        this.labelClass = backingProblem.labelClass;
        this.labelInverter = backingProblem.labelInverter;
    }

    @Override
    public Class getLabelClass() {
        return this.labelClass;
    }

    @Override
    public LabelInverter<L> getLabelInverter() {
        return this.labelInverter;
    }

    @Override
    public Map<L, Set<P>> getExamplesByLabel() {
        if (this.theInverseMap == null) {
            this.theInverseMap = new HashMap<L, Set<P>>();
            for (Comparable comparable : this.getLabels()) {
                this.theInverseMap.put(comparable, new HashSet());
            }
            for (Map.Entry entry : this.examples.entrySet()) {
                this.theInverseMap.get(entry.getValue()).add(entry.getKey());
            }
        }
        return this.theInverseMap;
    }

    @Override
    public MultiClassProblem<L, P> getScaledCopy(@NotNull ScalingModelLearner<P> scalingModelLearner) {
        if (!scalingModelLearner.equals(this.lastScalingModelLearner)) {
            this.scaledCopy = (MultiClassProblem)this.learnScaling(scalingModelLearner);
            this.lastScalingModelLearner = scalingModelLearner;
        }
        return this.scaledCopy;
    }

    @Override
    public MultiClassProblem<L, P> createScaledCopy(Map<P, L> scaledExamples, Map<P, Integer> scaledExampleIds, ScalingModel<P> learnedScalingModel) {
        return new MultiClassProblemImpl<L, P>(this.labelClass, this.labelInverter, scaledExamples, scaledExampleIds, learnedScalingModel);
    }

    @Override
    protected MultiClassProblem<L, P> makeFold(Set<P> heldOutPoints) {
        return new MultiClassProblemImpl<L, P>(this, heldOutPoints);
    }
}

