/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.jlibsvm.oneclass;

import edu.berkeley.compbio.jlibsvm.ImmutableSvmParameter;
import edu.berkeley.compbio.jlibsvm.ImmutableSvmParameterGrid;
import edu.berkeley.compbio.jlibsvm.ImmutableSvmParameterPoint;
import edu.berkeley.compbio.jlibsvm.SolutionVector;
import edu.berkeley.compbio.jlibsvm.SvmException;
import edu.berkeley.compbio.jlibsvm.oneclass.OneClassModel;
import edu.berkeley.compbio.jlibsvm.oneclass.OneClassProblem;
import edu.berkeley.compbio.jlibsvm.oneclass.OneClassSolver;
import edu.berkeley.compbio.jlibsvm.qmatrix.BooleanInvertingKernelQMatrix;
import edu.berkeley.compbio.jlibsvm.regression.RegressionModel;
import edu.berkeley.compbio.jlibsvm.regression.RegressionSVM;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OneClassSVC<L extends Comparable, P>
extends RegressionSVM<P, OneClassProblem<L, P>> {
    private static final Logger logger = Logger.getLogger(OneClassSVC.class);

    @Override
    public RegressionModel<P> train(OneClassProblem<L, P> problem, @NotNull ImmutableSvmParameter<Float, P> param) {
        ((RegressionSVM)this).validateParam(param);
        if (param instanceof ImmutableSvmParameterGrid && param.gridsearchBinaryMachinesIndependently) {
            throw new SvmException("Can't do grid search without cross-validation, which is not implemented for regression SVMs.");
        }
        RegressionModel<P> result = this.trainScaled(problem, (ImmutableSvmParameterPoint)param);
        return result;
    }

    private RegressionModel<P> trainScaled(OneClassProblem<L, P> problem, @NotNull ImmutableSvmParameterPoint<Float, P> param) {
        if (param.scalingModelLearner != null && param.scaleBinaryMachinesIndependently) {
            problem = problem.getScaledCopy(param.scalingModelLearner);
        }
        float remainingAlpha = param.nu * (float)problem.getNumExamples();
        float linearTerm = 0.0f;
        ArrayList solutionVectors = new ArrayList();
        int c = 0;
        for (Map.Entry example : problem.getExamples().entrySet()) {
            float initAlpha = remainingAlpha > 1.0f ? 1.0f : remainingAlpha;
            remainingAlpha -= initAlpha;
            SolutionVector sv = new SolutionVector(example.getKey(), true, linearTerm, initAlpha);
            sv.id = problem.getId(example.getKey());
            ++c;
            solutionVectors.add(sv);
        }
        BooleanInvertingKernelQMatrix qMatrix = new BooleanInvertingKernelQMatrix(param.kernel, problem.getNumExamples(), param.getCacheRows());
        OneClassSolver s = new OneClassSolver(solutionVectors, qMatrix, 1.0f, param.eps, param.shrinking);
        OneClassModel model = s.solve();
        model.param = param;
        model.label = problem.getLabel();
        model.setSvmType(this.getSvmType());
        model.compact();
        return model;
    }

    @Override
    public String getSvmType() {
        return "one_class_svc";
    }

    @Override
    public void validateParam(@NotNull ImmutableSvmParameterPoint<Float, P> param) {
        super.validateParam(param);
        if (param.C != 1.0f) {
            logger.warn("OneClassSVC ignores param.C, provided value " + param.C + " + not used");
        }
        if (param.probability) {
            throw new SvmException("one-class SVM probability output not supported yet");
        }
        if (param.nu <= 0.0f || param.nu > 1.0f) {
            throw new SvmException("nu <= 0 or nu > 1");
        }
    }
}

