/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.jlibsvm.regression;

import edu.berkeley.compbio.jlibsvm.ImmutableSvmParameter;
import edu.berkeley.compbio.jlibsvm.ImmutableSvmParameterGrid;
import edu.berkeley.compbio.jlibsvm.ImmutableSvmParameterPoint;
import edu.berkeley.compbio.jlibsvm.SolutionVector;
import edu.berkeley.compbio.jlibsvm.SvmException;
import edu.berkeley.compbio.jlibsvm.qmatrix.BooleanInvertingKernelQMatrix;
import edu.berkeley.compbio.jlibsvm.regression.RegressionModel;
import edu.berkeley.compbio.jlibsvm.regression.RegressionProblem;
import edu.berkeley.compbio.jlibsvm.regression.RegressionSVM;
import edu.berkeley.compbio.jlibsvm.regression.RegressionSolver;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EpsilonSVR<P, R extends RegressionProblem<P, R>>
extends RegressionSVM<P, R> {
    @Override
    public RegressionModel<P> train(R problem, @NotNull ImmutableSvmParameter<Float, P> param) {
        this.validateParam(param);
        if (param instanceof ImmutableSvmParameterGrid && param.gridsearchBinaryMachinesIndependently) {
            throw new SvmException("Can't do grid search without cross-validation, which is not implemented for regression SVMs.");
        }
        RegressionModel<P> result = this.trainScaled(problem, (ImmutableSvmParameterPoint)param);
        return result;
    }

    private RegressionModel<P> trainScaled(R problem, @NotNull ImmutableSvmParameterPoint<Float, P> param) {
        if (param.scalingModelLearner != null && param.scaleBinaryMachinesIndependently) {
            problem = (RegressionProblem)problem.getScaledCopy(param.scalingModelLearner);
        }
        float laplaceParameter = -1.0f;
        if (param.probability) {
            laplaceParameter = this.laplaceParameter(problem, param);
        }
        ArrayList solutionVectors = new ArrayList();
        for (Map.Entry example : problem.getExamples().entrySet()) {
            SolutionVector sv = new SolutionVector(example.getKey(), true, param.p - ((Float)example.getValue()).floatValue());
            sv.id = problem.getId(example.getKey());
            solutionVectors.add(sv);
            sv = new SolutionVector(example.getKey(), false, param.p + ((Float)example.getValue()).floatValue());
            sv.id = -problem.getId(example.getKey());
            solutionVectors.add(sv);
        }
        BooleanInvertingKernelQMatrix qMatrix = new BooleanInvertingKernelQMatrix(param.kernel, problem.getNumExamples(), param.getCacheRows());
        RegressionSolver s = new RegressionSolver(solutionVectors, qMatrix, param.C, param.eps, param.shrinking);
        RegressionModel model = s.solve();
        model.param = param;
        model.setSvmType(this.getSvmType());
        model.laplaceParameter = laplaceParameter;
        model.compact();
        return model;
    }

    @Override
    public String getSvmType() {
        return "epsilon_svr";
    }

    @Override
    public void validateParam(@NotNull ImmutableSvmParameter<Float, P> param) {
        super.validateParam(param);
        if (param.p < 0.0f) {
            throw new SvmException("p < 0");
        }
        if (param instanceof ImmutableSvmParameterPoint && ((ImmutableSvmParameterPoint)param).C <= 0.0f) {
            throw new SvmException("C <= 0");
        }
    }
}

