/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.jlibsvm.regression;

import edu.berkeley.compbio.jlibsvm.regression.RegressionProblem;
import edu.berkeley.compbio.ml.CrossValidationResults;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegressionCrossValidationResults<P, R extends RegressionProblem<P, R>>
extends CrossValidationResults {
    double meanSquaredError;
    double squaredCorrCoeff;

    public RegressionCrossValidationResults(RegressionProblem<P, R> problem, Map<P, Float> decisionValues) {
        double sumv = 0.0;
        double sumy = 0.0;
        double sumvv = 0.0;
        double sumyy = 0.0;
        double sumvy = 0.0;
        double total_error = 0.0;
        int numExamples = problem.getNumExamples();
        for (Map.Entry entry : problem.getExamples().entrySet()) {
            Object p = entry.getKey();
            Float y = (Float)entry.getValue();
            Float v = decisionValues.get(p);
            total_error += (double)((v.floatValue() - y.floatValue()) * (v.floatValue() - y.floatValue()));
            sumv += (double)v.floatValue();
            sumy += (double)y.floatValue();
            sumvv += (double)(v.floatValue() * v.floatValue());
            sumyy += (double)(y.floatValue() * y.floatValue());
            sumvy += (double)(v.floatValue() * y.floatValue());
        }
        this.meanSquaredError = total_error / (double)numExamples;
        this.squaredCorrCoeff = ((double)numExamples * sumvy - sumv * sumy) * ((double)numExamples * sumvy - sumv * sumy) / (((double)numExamples * sumvv - sumv * sumv) * ((double)numExamples * sumyy - sumy * sumy));
        System.out.print("Cross Validation Mean squared error = " + this.meanSquaredError + "\n");
        System.out.print("Cross Validation Squared correlation coefficient = " + this.squaredCorrCoeff + "\n");
    }

    @Override
    public float accuracy() {
        return 0.0f;
    }

    @Override
    public float accuracyGivenClassified() {
        return 0.0f;
    }

    @Override
    public float unknown() {
        return 0.0f;
    }
}

