/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.jlibsvm.regression;

import edu.berkeley.compbio.jlibsvm.ExplicitSvmProblemImpl;
import edu.berkeley.compbio.jlibsvm.SvmException;
import edu.berkeley.compbio.jlibsvm.regression.RegressionProblem;
import edu.berkeley.compbio.jlibsvm.scaler.ScalingModel;
import edu.berkeley.compbio.jlibsvm.scaler.ScalingModelLearner;
import edu.berkeley.compbio.jlibsvm.util.SubtractionMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegressionProblemImpl<P, R extends RegressionProblem<P, R>>
extends ExplicitSvmProblemImpl<Float, P, R>
implements RegressionProblem<P, R> {
    private ScalingModelLearner<P> lastScalingModelLearner = null;
    private R scaledCopy = null;

    public RegressionProblemImpl(Map<P, Float> examples, Map<P, Integer> exampleIds, ScalingModel<P> scalingModel) {
        super(examples, exampleIds, scalingModel);
    }

    public RegressionProblemImpl(Map<P, Float> examples, Map<P, Integer> exampleIds, ScalingModel<P> scalingModel, Set<P> heldOutPoints) {
        super(examples, exampleIds, scalingModel, heldOutPoints);
    }

    public RegressionProblemImpl(RegressionProblemImpl<P, R> backingProblem, Set<P> heldOutPoints) {
        super(new SubtractionMap(backingProblem.examples, heldOutPoints), backingProblem.exampleIds, backingProblem.scalingModel, heldOutPoints);
    }

    public RegressionProblemImpl(Map<P, Float> examples, Map<P, Integer> exampleIds) {
        super(examples, exampleIds);
    }

    @Override
    public List<Float> getLabels() {
        throw new SvmException("Shouldn't try to get unique target values for a regression problem");
    }

    @Override
    protected R makeFold(Set<P> heldOutPoints) {
        return (R)new RegressionProblemImpl<P, R>(this, heldOutPoints);
    }

    @Override
    public R getScaledCopy(@NotNull ScalingModelLearner<P> scalingModelLearner) {
        if (!scalingModelLearner.equals(this.lastScalingModelLearner)) {
            this.scaledCopy = (RegressionProblem)this.learnScaling(scalingModelLearner);
            this.lastScalingModelLearner = scalingModelLearner;
        }
        return this.scaledCopy;
    }

    @Override
    public R createScaledCopy(Map<P, Float> scaledExamples, Map<P, Integer> scaledExampleIds, ScalingModel<P> learnedScalingModel) {
        return (R)new RegressionProblemImpl<P, R>(scaledExamples, scaledExampleIds, learnedScalingModel);
    }
}

