/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.jlibsvm.regression;

import edu.berkeley.compbio.jlibsvm.ImmutableSvmParameter;
import edu.berkeley.compbio.jlibsvm.SVM;
import edu.berkeley.compbio.jlibsvm.regression.RegressionCrossValidationResults;
import edu.berkeley.compbio.jlibsvm.regression.RegressionModel;
import edu.berkeley.compbio.jlibsvm.regression.RegressionProblem;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RegressionSVM<P, R extends RegressionProblem<P, R>>
extends SVM<Float, P, R> {
    private static final Logger logger = Logger.getLogger(RegressionSVM.class);
    private final float SQRT_2 = (float)Math.sqrt(2.0);

    protected float laplaceParameter(RegressionProblem<P, R> problem, @NotNull ImmutableSvmParameter<Float, P> param) {
        float mae = 0.0f;
        Map<P, Float> ymv = this.continuousCrossValidation(problem, param);
        for (Map.Entry<P, Float> entry : ymv.entrySet()) {
            float newVal = ((Float)problem.getTargetValue(entry.getKey())).floatValue() - entry.getValue().floatValue();
            entry.setValue(Float.valueOf(newVal));
            mae += Math.abs(newVal);
        }
        float std = this.SQRT_2 * (mae /= (float)problem.getNumExamples());
        int count = 0;
        mae = 0.0f;
        for (Map.Entry<P, Float> entry : ymv.entrySet()) {
            float absVal = Math.abs(entry.getValue().floatValue());
            if (absVal > 5.0f * std) {
                ++count;
                continue;
            }
            mae += absVal;
        }
        logger.info("Prob. model for test data: target value = predicted value + z");
        logger.info("z: Laplace distribution e^(-|z|/sigma)/(2sigma),sigma=" + (mae /= (float)(problem.getNumExamples() - count)));
        return mae;
    }

    public abstract RegressionModel<P> train(R var1, @NotNull ImmutableSvmParameter<Float, P> var2);

    @Override
    public void validateParam(@NotNull ImmutableSvmParameter<Float, P> param) {
        super.validateParam(param);
    }

    public RegressionCrossValidationResults<P, R> performCrossValidation(R problem, @NotNull ImmutableSvmParameter<Float, P> param) {
        Map<P, Float> decisionValues = this.continuousCrossValidation(problem, param);
        RegressionCrossValidationResults cv = new RegressionCrossValidationResults(problem, decisionValues);
        return cv;
    }
}

