/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.ml.cluster;

import edu.berkeley.compbio.ml.cluster.AbstractCluster;
import edu.berkeley.compbio.ml.cluster.CentroidCluster;
import edu.berkeley.compbio.ml.cluster.Clusterable;
import java.util.Formatter;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCentroidCluster<T extends Clusterable<T>>
extends AbstractCluster<T>
implements CentroidCluster<T> {
    private static final Logger logger = Logger.getLogger(AbstractCentroidCluster.class);
    protected final T centroid;
    protected double sumOfSquareDistances = 0.0;

    public AbstractCentroidCluster(int id, T centroid) {
        super(id);
        this.centroid = centroid;
        if (centroid != null) {
            centroid.doneLabelling();
            this.mutableWeightedLabels.addAll(centroid.getImmutableWeightedLabels());
        }
        logger.debug("Created cluster with centroid: " + centroid);
    }

    @Override
    public T getCentroid() {
        return this.centroid;
    }

    @Override
    public void setSumOfSquareDistances(double v) {
        this.sumOfSquareDistances = v;
    }

    public String toString() {
        Formatter f = new Formatter();
        f.format("[Cluster %d] n=%d sd=%.2f", this.id, this.getN(), this.getStdDev());
        return f.out().toString();
    }

    @Override
    public double getStdDev() {
        return Math.sqrt(this.sumOfSquareDistances / (double)this.getN());
    }

    @Override
    public void addToSumOfSquareDistances(double v) {
        this.sumOfSquareDistances += v;
    }
}

