/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.ml.cluster;

import com.davidsoergel.stats.DissimilarityMeasure;
import edu.berkeley.compbio.ml.cluster.AbstractClusteringMethod;
import edu.berkeley.compbio.ml.cluster.Cluster;
import edu.berkeley.compbio.ml.cluster.ClusterException;
import edu.berkeley.compbio.ml.cluster.Clusterable;
import edu.berkeley.compbio.ml.cluster.ClusterableIteratorFactory;
import edu.berkeley.compbio.ml.cluster.NoGoodClusterException;
import edu.berkeley.compbio.ml.cluster.OnlineClusteringMethod;
import edu.berkeley.compbio.ml.cluster.ProhibitionModel;
import edu.berkeley.compbio.ml.cluster.UnsupervisedClusteringMethod;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractUnsupervisedOnlineClusteringMethod<T extends Clusterable<T>, C extends Cluster<T>>
extends AbstractClusteringMethod<T, C>
implements OnlineClusteringMethod<T>,
UnsupervisedClusteringMethod<T> {
    private static final Logger logger = Logger.getLogger(AbstractUnsupervisedOnlineClusteringMethod.class);

    protected AbstractUnsupervisedOnlineClusteringMethod(DissimilarityMeasure<T> dm, Set<String> potentialTrainingBins, Map<String, Set<String>> predictLabelSets, ProhibitionModel<T> prohibitionModel, Set<String> testLabels) {
        super(dm, potentialTrainingBins, predictLabelSets, prohibitionModel, testLabels);
    }

    @Override
    public void train(ClusterableIteratorFactory<T> trainingCollectionIteratorFactory, int trainingEpochs) throws ClusterException {
        for (int i = 0; i < trainingEpochs; ++i) {
            if (!this.trainOneIteration(trainingCollectionIteratorFactory)) continue;
            logger.debug("Steady state, done after " + (i + 1) + " iterations!");
            break;
        }
        this.removeEmptyClusters();
        this.normalizeClusterLabelProbabilities();
    }

    protected boolean trainOneIteration(ClusterableIteratorFactory<T> trainingCollectionIteratorFactory) throws ClusterException {
        int changed = 0;
        Object trainingIterator = trainingCollectionIteratorFactory.next();
        int c = 0;
        try {
            while (true) {
                try {
                    Object p = trainingIterator.nextFullyLabelled();
                    if (this.add(p)) {
                        ++changed;
                    }
                }
                catch (NoGoodClusterException e) {
                    // empty catch block
                }
                ++c;
            }
        }
        catch (NoSuchElementException e) {
            int changedProportion = changed == 0 ? 0 : (int)(100.0 * (double)changed / (double)c);
            logger.debug("Changed cluster assignment of " + changed + " points (" + changedProportion + "%)\n");
            if (logger.isDebugEnabled()) {
                logger.debug("\n" + this.clusteringStats());
            }
            return changed == 0;
        }
    }
}

