/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.ml.cluster;

import edu.berkeley.compbio.ml.cluster.AbstractCentroidCluster;
import edu.berkeley.compbio.ml.cluster.AdditiveClusterable;
import edu.berkeley.compbio.ml.cluster.CentroidCluster;
import edu.berkeley.compbio.ml.cluster.Cluster;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdditiveCentroidCluster<T extends AdditiveClusterable<T>>
extends AbstractCentroidCluster<T> {
    private static final Logger logger = Logger.getLogger(AdditiveCentroidCluster.class);

    public AdditiveCentroidCluster(int id, T centroid) {
        super(id, centroid);
    }

    @Override
    public synchronized boolean add(T point2) {
        super.add(point2);
        ((AdditiveClusterable)this.centroid).incrementBy(point2);
        return true;
    }

    @Override
    public boolean addAll(Cluster<T> otherCluster) {
        super.addAll(otherCluster);
        int otherN = otherCluster.getN();
        ((AdditiveClusterable)this.centroid).incrementByWeighted((AdditiveClusterable)((CentroidCluster)otherCluster).getCentroid(), otherN / (otherN + this.getN()));
        return true;
    }

    @Override
    public boolean remove(T point2) {
        super.remove(point2);
        ((AdditiveClusterable)this.centroid).decrementBy(point2);
        return true;
    }

    @Override
    public boolean removeAll(Cluster<T> otherCluster) {
        super.removeAll(otherCluster);
        int otherN = otherCluster.getN();
        ((AdditiveClusterable)this.centroid).decrementByWeighted((AdditiveClusterable)((CentroidCluster)otherCluster).getCentroid(), otherN / (otherN + this.getN()));
        logger.debug("Cluster removed " + otherCluster);
        return true;
    }
}

