/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.ml.cluster;

import edu.berkeley.compbio.ml.cluster.AdditiveCentroidCluster;
import edu.berkeley.compbio.ml.cluster.AdditiveClusterable;
import edu.berkeley.compbio.ml.cluster.Cluster;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchAdditiveCentroidCluster<T extends AdditiveClusterable<T>>
extends AdditiveCentroidCluster<T> {
    private static final Logger logger = Logger.getLogger(BatchAdditiveCentroidCluster.class);
    private final Set<T> thePoints = new HashSet<T>();

    public BatchAdditiveCentroidCluster(int id, T centroid) throws CloneNotSupportedException {
        super(id, centroid);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("\nCluster:");
        sb.append(" ").append(this.centroid).append("\n");
        for (AdditiveClusterable t : this.thePoints) {
            sb.append(" ").append(t).append("\n");
        }
        return sb.toString();
    }

    @Override
    public synchronized boolean add(T point2) {
        if (this.thePoints.add(point2)) {
            super.add(point2);
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(Cluster<T> otherCluster) {
        if (this.thePoints.addAll(((BatchAdditiveCentroidCluster)otherCluster).getPoints())) {
            super.addAll(otherCluster);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(T point2) {
        if (this.thePoints.remove(point2)) {
            super.remove(point2);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Cluster<T> otherCluster) {
        if (this.thePoints.removeAll(((BatchAdditiveCentroidCluster)otherCluster).getPoints())) {
            super.removeAll(otherCluster);
            return true;
        }
        return false;
    }

    public Set<T> getPoints() {
        return this.thePoints;
    }
}

