/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.ml.cluster;

import com.davidsoergel.dsutils.DSArrayUtils;
import com.davidsoergel.dsutils.LabellableImpl;
import com.davidsoergel.stats.DoubleArrayContainer;
import edu.berkeley.compbio.ml.cluster.AdditiveClusterable;
import org.apache.commons.lang.NotImplementedException;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterableDoubleArray
extends LabellableImpl<String>
implements AdditiveClusterable<ClusterableDoubleArray>,
DoubleArrayContainer {
    private static final Logger logger = Logger.getLogger(ClusterableDoubleArray.class);
    protected String id;
    protected double[] data;
    protected Double dataSum;
    private String label;

    public ClusterableDoubleArray() {
    }

    public ClusterableDoubleArray(String id, double[] data) {
        this.id = id;
        this.data = data;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public ClusterableDoubleArray clone() {
        return new ClusterableDoubleArray(this.id, (double[])this.data.clone());
    }

    @Override
    public void decrementBy(ClusterableDoubleArray object) {
        DSArrayUtils.decrementBy(this.data, object.data);
        this.dataSum = null;
    }

    @Override
    public void decrementByWeighted(ClusterableDoubleArray object, double weight) {
        DSArrayUtils.decrementByWeighted(this.data, object.data, weight);
        this.dataSum = null;
    }

    @Override
    public void incrementBy(ClusterableDoubleArray object) {
        DSArrayUtils.incrementBy(this.data, object.data);
        this.dataSum = null;
    }

    @Override
    public void incrementByWeighted(ClusterableDoubleArray object, double weight) {
        DSArrayUtils.incrementByWeighted(this.data, object.data, weight);
        this.dataSum = null;
    }

    @Override
    public ClusterableDoubleArray minus(ClusterableDoubleArray object) {
        return new ClusterableDoubleArray(this.id + "+" + object.getId(), DSArrayUtils.minus(this.data, object.data));
    }

    @Override
    public void multiplyBy(double scalar) {
        DSArrayUtils.multiplyBy(this.data, scalar);
        this.dataSum = null;
    }

    @Override
    public ClusterableDoubleArray plus(ClusterableDoubleArray object) {
        return new ClusterableDoubleArray(this.id + "+" + object.getId(), DSArrayUtils.plus(this.data, object.data));
    }

    @Override
    public ClusterableDoubleArray times(double scalar) {
        return new ClusterableDoubleArray(this.id + "*" + scalar, DSArrayUtils.times(this.data, scalar));
    }

    @Override
    public boolean equalValue(ClusterableDoubleArray object) {
        return this.id.equals(object.id) && DSArrayUtils.equalWithinFPError(this.data, object.data);
    }

    @Override
    public String getId() {
        return null;
    }

    @Override
    public double[] getArray() {
        return this.data;
    }

    @Override
    public double getArraySum() {
        if (this.dataSum == null) {
            this.dataSum = DSArrayUtils.sum(this.data);
        }
        return this.dataSum;
    }

    public double get(int i) {
        return this.data[i];
    }

    public String getExclusiveLabel() {
        return this.label;
    }

    public String getSourceId() {
        throw new NotImplementedException();
    }

    public int length() {
        return this.data.length;
    }
}

