/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.ml.cluster;

import com.davidsoergel.dsutils.DSArrayUtils;
import com.davidsoergel.dsutils.collections.DSCollectionUtils;
import com.davidsoergel.stats.EqualWeightHistogram1D;
import com.davidsoergel.stats.Histogram1D;
import com.davidsoergel.stats.StatsException;
import com.davidsoergel.trees.htpn.HierarchicalTypedPropertyNode;
import edu.berkeley.compbio.ml.MultiClassCrossValidationResults;
import edu.berkeley.compbio.ml.cluster.ClusterRuntimeException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistanceBasedMultiClassCrossValidationResults<L extends Comparable>
extends MultiClassCrossValidationResults<L> {
    private static final Logger logger = Logger.getLogger(DistanceBasedMultiClassCrossValidationResults.class);
    private final ArrayList<Double> predictionDistances = new ArrayList();
    private final ArrayList<Double> predictionDistancesWithPrecisionCost = new ArrayList();
    private List<Double> labelWithinClusterProbabilities = new ArrayList<Double>();
    private int shouldHaveBeenUnknown = 0;
    private int shouldNotHaveBeenUnknown = 0;
    private int other = 0;
    private int shouldNotHaveBeenOther = 0;

    public void addSample(L realLabel, L predictedLabel, double clusterProb, double broadWrongness, double detailedWrongness) {
        super.addSample(realLabel, predictedLabel);
        this.predictionDistances.add(broadWrongness);
        this.predictionDistancesWithPrecisionCost.add(detailedWrongness);
        this.labelWithinClusterProbabilities.add(clusterProb);
    }

    public ArrayList<Double> getPredictionDistances() {
        return this.predictionDistances;
    }

    public ArrayList<Double> getPredictionDistancesWithPrecisionCost() {
        return this.predictionDistancesWithPrecisionCost;
    }

    public void finish() {
        if (DSCollectionUtils.allElementsEqual(this.labelWithinClusterProbabilities, 1.0)) {
            this.labelWithinClusterProbabilities = null;
        }
    }

    public Double[] getLabelWithinClusterProbabilitiesArray() {
        return this.labelWithinClusterProbabilities == null ? null : this.labelWithinClusterProbabilities.toArray(DSArrayUtils.EMPTY_DOUBLE_OBJECT_ARRAY);
    }

    public void putResults(HierarchicalTypedPropertyNode<String, Serializable, ?> resultsNode, String labelDistancesName, Map<L, String> friendlyLabelMap) {
        resultsNode.addChild("numPopulatedRealLabels", (Serializable)Integer.valueOf(this.numPopulatedRealLabels()));
        resultsNode.addChild("numPredictedLabels", (Serializable)Integer.valueOf(this.numPredictedLabels()));
        resultsNode.addChild("labelWithinClusterProbabilities", (Serializable)this.getLabelWithinClusterProbabilitiesArray());
        resultsNode.addChild("accuracy", (Serializable)new Double(this.accuracy()));
        resultsNode.addChild("accuracyGivenClassified", (Serializable)Float.valueOf(this.accuracyGivenClassified()));
        resultsNode.addChild("classNormalizedSensitivity", (Serializable)Float.valueOf(this.classNormalizedSensitivity()));
        resultsNode.addChild("classNormalizedSpecificity", (Serializable)Float.valueOf(this.classNormalizedSpecificity()));
        resultsNode.addChild("classNormalizedPrecision", (Serializable)Float.valueOf(this.classNormalizedPrecision()));
        resultsNode.addChild("unknownLabel", (Serializable)Float.valueOf(this.unknown()));
        resultsNode.addChild("shouldHaveBeenUnknown", (Serializable)Integer.valueOf(this.shouldHaveBeenUnknown));
        resultsNode.addChild("shouldNotHaveBeenUnknown", (Serializable)Integer.valueOf(this.shouldNotHaveBeenUnknown));
        resultsNode.addChild("other", (Serializable)Integer.valueOf(this.other));
        resultsNode.addChild("shouldNotHaveBeenOther", (Serializable)Integer.valueOf(this.shouldNotHaveBeenOther));
        DistanceBasedMultiClassCrossValidationResults.storeLabelDistances(labelDistancesName, this.getPredictionDistances(), resultsNode);
        DistanceBasedMultiClassCrossValidationResults.storeLabelDistances(labelDistancesName + "ToSample", this.getPredictionDistancesWithPrecisionCost(), resultsNode);
        resultsNode.addChild("classLabels", (Serializable)this.getLabels().toArray(DSArrayUtils.EMPTY_STRING_ARRAY));
        resultsNode.addChild("friendlyLabels", (Serializable)this.getFriendlyLabels(friendlyLabelMap));
        resultsNode.addChild("sensitivity", (Serializable)DSArrayUtils.castToDouble(this.getSensitivities()));
        resultsNode.addChild("specificity", (Serializable)DSArrayUtils.castToDouble(this.getSpecificities()));
        resultsNode.addChild("precision", (Serializable)DSArrayUtils.castToDouble(this.getPrecisions()));
        resultsNode.addChild("predictedCounts", (Serializable)DSArrayUtils.castToDouble(this.getPredictedCounts()));
        resultsNode.addChild("actualCounts", (Serializable)DSArrayUtils.castToDouble(this.getActualCounts()));
        ArrayList<Integer> flattenedConfusionMatrix = new ArrayList<Integer>();
        SortedSet labels = this.getLabels();
        for (Comparable actualLabel : labels) {
            for (Comparable predictedLabel : labels) {
                flattenedConfusionMatrix.add(this.getCount(actualLabel, predictedLabel));
            }
        }
        resultsNode.addChild("confusionMatrix", (Serializable)DSArrayUtils.toPrimitiveArray(flattenedConfusionMatrix));
    }

    public static void storeLabelDistances(String labelDistanceName, List<Double> labelDistances, HierarchicalTypedPropertyNode<String, Serializable, ?> resultsNode) {
        resultsNode.addChild(labelDistanceName, (Serializable)labelDistances.toArray(DSArrayUtils.EMPTY_DOUBLE_OBJECT_ARRAY));
        if (!labelDistances.isEmpty()) {
            ArrayList<Double> d = new ArrayList<Double>(labelDistances.size());
            for (Double labelDistance : labelDistances) {
                if (labelDistance < 0.0) {
                    d.add(0.0);
                    continue;
                }
                if (labelDistance > 1.0E100) continue;
                d.add(labelDistance);
            }
            if (d.isEmpty()) {
                logger.warn("All distances were enormous (e.g., UNKNOWN_DISTANCE); no samples were predicted at all");
            } else {
                try {
                    EqualWeightHistogram1D h = new EqualWeightHistogram1D(100, DSArrayUtils.toPrimitive(d.toArray(new Double[d.size()])));
                    resultsNode.addChild(labelDistanceName + "90", (Serializable)Double.valueOf(((Histogram1D)h).topOfBin(89)));
                    resultsNode.addChild(labelDistanceName + "95", (Serializable)Double.valueOf(((Histogram1D)h).topOfBin(94)));
                    resultsNode.addChild(labelDistanceName + "99", (Serializable)Double.valueOf(((Histogram1D)h).topOfBin(98)));
                }
                catch (StatsException e) {
                    throw new ClusterRuntimeException(e);
                }
                double mean = DSArrayUtils.mean(d);
                if (Double.isInfinite(mean)) {
                    logger.warn("labelDistance mean is Infinity");
                } else {
                    resultsNode.addChild(labelDistanceName + "MeanGivenClassified", (Serializable)Double.valueOf(mean));
                    resultsNode.addChild(labelDistanceName + "StdDevGivenClassified", (Serializable)Double.valueOf(DSArrayUtils.stddev(d, mean)));
                }
            }
        }
    }

    public void incrementShouldHaveBeenUnknown() {
        ++this.shouldHaveBeenUnknown;
    }

    public void incrementShouldNotHaveBeenUnknown() {
        ++this.shouldNotHaveBeenUnknown;
    }

    public void incrementOther() {
        ++this.other;
    }

    public void incrementShouldNotHaveBeenOther() {
        ++this.shouldNotHaveBeenOther;
    }
}

