/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.ml.cluster.bayesian;

import com.davidsoergel.stats.DissimilarityMeasure;
import com.davidsoergel.stats.ProbabilisticDissimilarityMeasure;
import edu.berkeley.compbio.ml.cluster.AbstractSupervisedOnlineClusteringMethod;
import edu.berkeley.compbio.ml.cluster.AdditiveClusterable;
import edu.berkeley.compbio.ml.cluster.CentroidCluster;
import edu.berkeley.compbio.ml.cluster.CentroidClusteringUtils;
import edu.berkeley.compbio.ml.cluster.ClusterMove;
import edu.berkeley.compbio.ml.cluster.ClusterRuntimeException;
import edu.berkeley.compbio.ml.cluster.ClusterableIterator;
import edu.berkeley.compbio.ml.cluster.NoGoodClusterException;
import edu.berkeley.compbio.ml.cluster.PointClusterFilter;
import edu.berkeley.compbio.ml.cluster.ProhibitionModel;
import edu.berkeley.compbio.ml.cluster.PrototypeBasedCentroidClusteringMethod;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NearestNeighborClustering<T extends AdditiveClusterable<T>>
extends AbstractSupervisedOnlineClusteringMethod<T, CentroidCluster<T>>
implements PrototypeBasedCentroidClusteringMethod<T> {
    private static final Logger logger = Logger.getLogger(NearestNeighborClustering.class);
    protected final double unknownDistanceThreshold;

    public NearestNeighborClustering(DissimilarityMeasure<T> dm, double unknownDistanceThreshold, Set<String> potentialTrainingBins, Map<String, Set<String>> predictLabelSets, ProhibitionModel<T> prohibitionModel, Set<String> testLabels) {
        super(dm, potentialTrainingBins, predictLabelSets, prohibitionModel, testLabels);
        this.unknownDistanceThreshold = unknownDistanceThreshold;
    }

    @Override
    public String shortClusteringStats() {
        return CentroidClusteringUtils.shortClusteringStats(this.getClusters(), this.measure);
    }

    @Override
    public void computeClusterStdDevs(ClusterableIterator<T> theDataPointProvider) {
        CentroidClusteringUtils.computeClusterStdDevs(this.getClusters(), this.measure, this.getAssignments(), theDataPointProvider);
    }

    @Override
    public String clusteringStats() {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        CentroidClusteringUtils.writeClusteringStatsToStream(this.getClusters(), this.measure, b);
        return b.toString();
    }

    @Override
    public void writeClusteringStatsToStream(OutputStream outf) {
        CentroidClusteringUtils.writeClusteringStatsToStream(this.getClusters(), this.measure, outf);
    }

    @Override
    public ClusterMove<T, CentroidCluster<T>> bestClusterMove(T p) throws NoGoodClusterException {
        ClusterMove result = new ClusterMove();
        result.secondBestDistance = Double.POSITIVE_INFINITY;
        result.bestDistance = Double.POSITIVE_INFINITY;
        PointClusterFilter<T> clusterFilter = this.prohibitionModel == null ? null : this.prohibitionModel.getFilter(p);
        for (CentroidCluster cluster : this.getClusters()) {
            if (clusterFilter != null && clusterFilter.isProhibited(cluster)) continue;
            double distance = this.measure instanceof ProbabilisticDissimilarityMeasure ? ((ProbabilisticDissimilarityMeasure)this.measure).distanceFromTo(p, cluster.getCentroid(), (Double)this.clusterPriors.get(cluster)) : this.measure.distanceFromTo(p, cluster.getCentroid());
            if (distance <= result.bestDistance) {
                result.secondBestDistance = result.bestDistance;
                result.bestDistance = distance;
                result.bestCluster = cluster;
                continue;
            }
            if (!(distance <= result.secondBestDistance)) continue;
            result.secondBestDistance = distance;
        }
        if (result.bestCluster == null) {
            throw new ClusterRuntimeException("None of the " + this.getNumClusters() + " clusters matched: " + p);
        }
        if (result.bestDistance > this.unknownDistanceThreshold) {
            throw new NoGoodClusterException("Best distance " + result.bestDistance + " > threshold " + this.unknownDistanceThreshold);
        }
        return result;
    }
}

