/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.ml.cluster.hierarchical;

import com.davidsoergel.dsutils.collections.IndexedSymmetric2dBiMapWithDefault;
import com.davidsoergel.dsutils.collections.OrderedPair;
import com.davidsoergel.dsutils.collections.UnorderedPair;
import com.davidsoergel.stats.DissimilarityMeasure;
import com.davidsoergel.trees.PhylogenyNode;
import edu.berkeley.compbio.ml.cluster.ClusterMove;
import edu.berkeley.compbio.ml.cluster.Clusterable;
import edu.berkeley.compbio.ml.cluster.NoGoodClusterException;
import edu.berkeley.compbio.ml.cluster.PointClusterFilter;
import edu.berkeley.compbio.ml.cluster.ProhibitionModel;
import edu.berkeley.compbio.ml.cluster.hierarchical.Agglomerator;
import edu.berkeley.compbio.ml.cluster.hierarchical.BatchHierarchicalClusteringMethod;
import edu.berkeley.compbio.ml.cluster.hierarchical.HierarchicalCentroidCluster;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchAgglomerativeClusteringMethod<T extends Clusterable<T>>
extends BatchHierarchicalClusteringMethod<T> {
    private static final Logger logger = Logger.getLogger(BatchAgglomerativeClusteringMethod.class);
    public static final Float LONG_DISTANCE = Float.valueOf(Float.MAX_VALUE);
    protected final Agglomerator<T> agglomerator;
    protected IndexedSymmetric2dBiMapWithDefault<HierarchicalCentroidCluster<T>, Float> theActiveNodeDistanceMatrix;
    protected HierarchicalCentroidCluster<T> theRoot;
    protected final AtomicInteger nextId = new AtomicInteger(0);
    private Float threshold;

    @Override
    public void setThreshold(float threshold) {
        this.threshold = Float.valueOf(threshold);
    }

    @Override
    public void setDistanceMatrix(IndexedSymmetric2dBiMapWithDefault<HierarchicalCentroidCluster<T>, Float> theActiveNodeDistanceMatrix) {
        this.theActiveNodeDistanceMatrix = theActiveNodeDistanceMatrix;
        this.nextId.set(theActiveNodeDistanceMatrix.getNextId());
    }

    public BatchAgglomerativeClusteringMethod(DissimilarityMeasure<T> dm, Set<String> potentialTrainingBins, Map<String, Set<String>> predictLabelSets, ProhibitionModel<T> prohibitionModel, Set<String> testLabels, Agglomerator agg) {
        super(dm, potentialTrainingBins, predictLabelSets, prohibitionModel, testLabels);
        this.agglomerator = agg;
        this.theActiveNodeDistanceMatrix = new IndexedSymmetric2dBiMapWithDefault(LONG_DISTANCE);
        this.nextId.set(this.theActiveNodeDistanceMatrix.getNextId());
    }

    public BatchAgglomerativeClusteringMethod(DissimilarityMeasure<T> dm, Set<String> potentialTrainingBins, Map<String, Set<String>> predictLabelSets, ProhibitionModel<T> prohibitionModel, Set<String> testLabels, ArrayList<HierarchicalCentroidCluster<T>> theClusters, Map<String, HierarchicalCentroidCluster<T>> assignments, int n, Agglomerator agg, IndexedSymmetric2dBiMapWithDefault<HierarchicalCentroidCluster<T>, Float> theActiveNodeDistanceMatrix) {
        super(dm, potentialTrainingBins, predictLabelSets, prohibitionModel, testLabels, theClusters, assignments, n);
        this.agglomerator = agg;
        this.theActiveNodeDistanceMatrix = theActiveNodeDistanceMatrix;
        this.nextId.set(theActiveNodeDistanceMatrix.getNextId());
    }

    @Override
    public IndexedSymmetric2dBiMapWithDefault<HierarchicalCentroidCluster<T>, Float> getDistanceMatrix() {
        return this.theActiveNodeDistanceMatrix;
    }

    @Override
    public void createClusters() {
    }

    @Override
    public synchronized void train() {
        Collection<HierarchicalCentroidCluster<T>> remainingKeys;
        this.setN(this.theActiveNodeDistanceMatrix.numKeys());
        while (!this.theActiveNodeDistanceMatrix.isEmpty()) {
            OrderedPair<UnorderedPair<HierarchicalCentroidCluster<T>>, Float> smallest = this.theActiveNodeDistanceMatrix.getKeyPairAndSmallestValue();
            UnorderedPair<HierarchicalCentroidCluster<T>> pair = smallest.getKey1();
            if (smallest.getKey2().floatValue() > this.threshold.floatValue()) break;
            HierarchicalCentroidCluster<T> a = pair.getKey1();
            HierarchicalCentroidCluster<T> b = pair.getKey2();
            assert (a.getParent() == null);
            assert (b.getParent() == null);
            assert (a.getWeight() != null);
            assert (b.getWeight() != null);
            HierarchicalCentroidCluster<T> composite = this.agglomerator.joinNodes(this.nextId.getAndIncrement(), a, b, this.theActiveNodeDistanceMatrix);
            this.theActiveNodeDistanceMatrix.remove(a);
            this.theActiveNodeDistanceMatrix.remove(b);
            this.addCluster(composite);
            this.theRoot = composite;
            assert (composite.getParent() == null);
            assert (!composite.getChildren().isEmpty());
            assert (composite.getWeight() != null);
        }
        if ((remainingKeys = this.theActiveNodeDistanceMatrix.getKeys()).size() > 1) {
            this.theRoot = new HierarchicalCentroidCluster<Object>(this.nextId.getAndIncrement(), null);
            for (HierarchicalCentroidCluster<T> remainingKey : remainingKeys) {
                remainingKey.setParent((PhylogenyNode<T>)this.theRoot);
                remainingKey.setLength((Double)Double.MAX_VALUE);
            }
        }
        this.normalizeClusterLabelProbabilities();
    }

    @Override
    public ClusterMove<T, HierarchicalCentroidCluster<T>> bestClusterMove(T p) throws NoGoodClusterException {
        ClusterMove result = new ClusterMove();
        result.bestDistance = Double.POSITIVE_INFINITY;
        PointClusterFilter<T> clusterFilter = this.prohibitionModel == null ? null : this.prohibitionModel.getFilter(p);
        for (HierarchicalCentroidCluster theCluster : this.getClusters()) {
            double distance;
            if (clusterFilter != null && clusterFilter.isProhibited(theCluster) || !((distance = this.measure.distanceFromTo(p, theCluster.getCentroid())) < result.bestDistance)) continue;
            result.bestCluster = theCluster;
            result.bestDistance = distance;
        }
        if (result.bestCluster == null) {
            throw new NoGoodClusterException("No cluster found for point: " + p);
        }
        return result;
    }

    @Override
    public HierarchicalCentroidCluster<T> getTree() {
        return this.theRoot;
    }
}

