/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.ml.cluster.hierarchical;

import com.davidsoergel.dsutils.Labellable;
import com.davidsoergel.dsutils.collections.ImmutableHashWeightedSet;
import com.davidsoergel.dsutils.collections.MutableWeightedSet;
import com.davidsoergel.dsutils.collections.WeightedSet;
import com.davidsoergel.trees.BasicPhylogenyNode;
import edu.berkeley.compbio.ml.cluster.BasicCentroidCluster;
import edu.berkeley.compbio.ml.cluster.CentroidCluster;
import edu.berkeley.compbio.ml.cluster.Cluster;
import edu.berkeley.compbio.ml.cluster.Clusterable;
import java.util.Formatter;
import java.util.Iterator;
import org.apache.commons.lang.NotImplementedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchicalCentroidCluster<T extends Clusterable<T>>
extends BasicPhylogenyNode<CentroidCluster<T>>
implements CentroidCluster<T>,
Comparable<HierarchicalCentroidCluster<T>> {
    public HierarchicalCentroidCluster(int id, T sample) {
        super(new BasicCentroidCluster<T>(id, sample));
        this.setWeight(1.0);
    }

    @Override
    public HierarchicalCentroidCluster<T> clone() {
        return (HierarchicalCentroidCluster)super.clone();
    }

    @Override
    public String toString() {
        Formatter f = new Formatter();
        f.format("l=%.2f w=%.2f %s", this.length, this.weight, this.value);
        return f.out().toString();
    }

    @Override
    public void addToSumOfSquareDistances(double v) {
        throw new NotImplementedException();
    }

    @Override
    public T getCentroid() {
        return ((CentroidCluster)this.getPayload()).getCentroid();
    }

    @Override
    public double getStdDev() {
        throw new NotImplementedException();
    }

    @Override
    public void setSumOfSquareDistances(double i) {
        throw new NotImplementedException();
    }

    @Override
    public boolean add(T point2) {
        throw new NotImplementedException();
    }

    @Override
    public boolean addAll(Cluster<T> point2) {
        return ((CentroidCluster)this.getPayload()).addAll(point2);
    }

    @Override
    public WeightedSet<String> getDerivedLabelProbabilities() {
        return ((CentroidCluster)this.getPayload()).getDerivedLabelProbabilities();
    }

    @Override
    public int getId() {
        return ((CentroidCluster)this.getPayload()).getId();
    }

    @Override
    public int getN() {
        return ((CentroidCluster)this.getPayload()).getN();
    }

    @Override
    public WeightedSet<String> getImmutableWeightedLabels() {
        return ((CentroidCluster)this.getPayload()).getImmutableWeightedLabels();
    }

    public void doneLabelling() {
        ((Labellable)this.getPayload()).doneLabelling();
    }

    public MutableWeightedSet<String> getMutableWeightedLabels() {
        return ((Labellable)this.getPayload()).getMutableWeightedLabels();
    }

    @Override
    public boolean remove(T point2) {
        throw new NotImplementedException();
    }

    @Override
    public boolean removeAll(Cluster<T> point2) {
        throw new NotImplementedException();
    }

    @Override
    public void setDerivedLabelProbabilities(ImmutableHashWeightedSet<String> derivedLabelProbabilities) {
        throw new NotImplementedException();
    }

    @Override
    public void updateDerivedWeightedLabelsFromLocal() {
        ((CentroidCluster)this.getPayload()).updateDerivedWeightedLabelsFromLocal();
    }

    @Override
    public void toNewick(StringBuffer sb, String prefix, String tab, int minClusterSize, double minLabelProb) {
        String label;
        double labelProb;
        if (prefix != null) {
            sb.append(prefix);
        }
        if (!this.children.isEmpty()) {
            prefix = prefix == null ? null : prefix + tab;
            sb.append("(");
            Iterator i = this.children.iterator();
            while (i.hasNext()) {
                BasicPhylogenyNode child = (BasicPhylogenyNode)i.next();
                if (((CentroidCluster)child.getPayload()).getN() < minClusterSize) continue;
                child.toNewick(sb, prefix, tab, minClusterSize, minLabelProb);
                if (!i.hasNext()) continue;
                sb.append(",");
            }
            sb.append(")");
        }
        sb.append(this.getN());
        WeightedSet<String> labels = this.getDerivedLabelProbabilities();
        Iterator i$ = labels.keysInDecreasingWeightOrder().iterator();
        while (i$.hasNext() && !((labelProb = labels.getNormalized(label = (String)i$.next())) < minLabelProb)) {
            sb.append("_").append(label).append("=").append(String.format("%.2f", labelProb));
        }
        if (this.bootstrap != 0.0) {
            sb.append(":").append(this.bootstrap);
        }
    }

    @Override
    public int compareTo(HierarchicalCentroidCluster<T> o) {
        int oid;
        int id = this.getId();
        return id < (oid = o.getId()) ? -1 : (id > oid ? 1 : 0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HierarchicalCentroidCluster)) {
            return false;
        }
        return this.getId() == ((HierarchicalCentroidCluster)o).getId();
    }

    public int hashCode() {
        return this.getId();
    }
}

