/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.ml.cluster.hierarchical;

import com.davidsoergel.dsutils.collections.DSCollectionUtils;
import com.davidsoergel.dsutils.collections.IndexedSymmetric2dBiMapWithDefault;
import com.davidsoergel.dsutils.collections.InsertionTrackingSet;
import com.davidsoergel.dsutils.collections.OrderedPair;
import com.davidsoergel.dsutils.collections.SortedSymmetric2dBiMap;
import com.davidsoergel.dsutils.collections.SortedSymmetric2dBiMapWithDefault;
import com.davidsoergel.dsutils.collections.UnorderedPair;
import com.davidsoergel.dsutils.collections.UnorderedPairIterator;
import edu.berkeley.compbio.ml.cluster.SimpleClusterable;
import edu.berkeley.compbio.ml.cluster.hierarchical.HierarchicalCentroidCluster;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchicalClusteringStringDistanceMatrix
extends IndexedSymmetric2dBiMapWithDefault<HierarchicalCentroidCluster<SimpleClusterable<String>>, Float>
implements Serializable,
SortedSymmetric2dBiMap<HierarchicalCentroidCluster<SimpleClusterable<String>>, Float> {
    private static final Logger logger = Logger.getLogger(HierarchicalClusteringStringDistanceMatrix.class);
    private static final long serialVersionUID = 5L;

    public HierarchicalClusteringStringDistanceMatrix() {
    }

    public HierarchicalClusteringStringDistanceMatrix(Float defaultValue) {
        super(defaultValue);
    }

    public HierarchicalClusteringStringDistanceMatrix(HierarchicalClusteringStringDistanceMatrix cloneFrom) {
        this.setDefaultValue(cloneFrom.getDefaultValue());
        this.keys = new InsertionTrackingSet();
        Collection oldClusters = cloneFrom.getKeys();
        for (HierarchicalCentroidCluster oldCluster : oldClusters) {
            String name = ((SimpleClusterable)oldCluster.getCentroid()).getId();
            Integer id = cloneFrom.keys.indexOf(oldCluster);
            HierarchicalCentroidCluster<SimpleClusterable<String>> c = new HierarchicalCentroidCluster<SimpleClusterable<String>>(id, new SimpleClusterable<String>(name));
            c.getMutableWeightedLabels().add(name, 1.0, 1);
            c.doneLabelling();
            this.keys.put(c, id);
        }
        this.underlyingIntMap = new SortedSymmetric2dBiMapWithDefault(cloneFrom.underlyingIntMap);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.setDefaultValue((Float)stream.readObject());
        InsertionTrackingSet keyStrings = (InsertionTrackingSet)stream.readObject();
        this.keys = new InsertionTrackingSet();
        for (String name : keyStrings) {
            Integer id = keyStrings.indexOf(name);
            HierarchicalCentroidCluster<SimpleClusterable<String>> c = new HierarchicalCentroidCluster<SimpleClusterable<String>>(id, new SimpleClusterable<String>(name));
            c.getMutableWeightedLabels().add(name, 1.0, 1);
            c.doneLabelling();
            this.keys.put(c, id);
        }
        int count = 0;
        try {
            while (true) {
                int id1 = stream.readInt();
                int id2 = stream.readInt();
                float value = stream.readFloat();
                this.underlyingIntMap.put(id1, id2, Float.valueOf(value));
                ++count;
            }
        }
        catch (EOFException e) {
            logger.info("Loaded distance matrix from cache: " + this.keys.size() + " keys, " + count + " pairs");
            return;
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.getDefaultValue());
        InsertionTrackingSet<String> keyStrings = new InsertionTrackingSet<String>();
        for (HierarchicalCentroidCluster hierarchicalCentroidCluster : this.keys) {
            keyStrings.put(((SimpleClusterable)hierarchicalCentroidCluster.getCentroid()).getId(), this.keys.indexOf(hierarchicalCentroidCluster));
        }
        stream.writeObject(keyStrings);
        for (OrderedPair orderedPair : this.underlyingIntMap.keyPairToValueSorted.getSortedPairs()) {
            UnorderedPair idPair = (UnorderedPair)orderedPair.getKey1();
            int id1 = (Integer)idPair.getKey1();
            int id2 = (Integer)idPair.getKey2();
            float value = ((Float)orderedPair.getKey2()).floatValue();
            stream.writeInt(id1);
            stream.writeInt(id2);
            stream.writeFloat(value);
        }
    }

    public HierarchicalClusteringStringDistanceMatrix sample(int sampleSize) {
        if (sampleSize == 0) {
            return this;
        }
        HashSet clusters = new HashSet(this.getKeys());
        DSCollectionUtils.retainRandom(clusters, sampleSize);
        HierarchicalClusteringStringDistanceMatrix result = new HierarchicalClusteringStringDistanceMatrix((Float)this.getDefaultValue());
        UnorderedPairIterator pi = new UnorderedPairIterator(clusters, clusters);
        while (pi.hasNext()) {
            Object p = pi.next();
            result.put(p, this.get(p));
        }
        return result;
    }
}

