/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.ml.cluster.hierarchical;

import com.davidsoergel.stats.DissimilarityMeasure;
import edu.berkeley.compbio.ml.cluster.AbstractSupervisedOnlineClusteringMethod;
import edu.berkeley.compbio.ml.cluster.CentroidClusteringMethod;
import edu.berkeley.compbio.ml.cluster.CentroidClusteringUtils;
import edu.berkeley.compbio.ml.cluster.Clusterable;
import edu.berkeley.compbio.ml.cluster.ClusterableIterator;
import edu.berkeley.compbio.ml.cluster.ProhibitionModel;
import edu.berkeley.compbio.ml.cluster.hierarchical.HierarchicalCentroidCluster;
import edu.berkeley.compbio.ml.cluster.hierarchical.HierarchicalClusteringMethod;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OnlineHierarchicalClusteringMethod<T extends Clusterable<T>>
extends AbstractSupervisedOnlineClusteringMethod<T, HierarchicalCentroidCluster<T>>
implements CentroidClusteringMethod<T>,
HierarchicalClusteringMethod<T> {
    protected OnlineHierarchicalClusteringMethod(DissimilarityMeasure<T> dm, Set<String> potentialTrainingBins, Map<String, Set<String>> predictLabelSets, ProhibitionModel<T> prohibitionModel, Set<String> testLabels) {
        super(dm, potentialTrainingBins, predictLabelSets, prohibitionModel, testLabels);
    }

    @Override
    public String shortClusteringStats() {
        return CentroidClusteringUtils.shortClusteringStats(this.getClusters(), this.measure);
    }

    @Override
    public void computeClusterStdDevs(ClusterableIterator<T> theDataPointProvider) {
        CentroidClusteringUtils.computeClusterStdDevs(this.getClusters(), this.measure, this.getAssignments(), theDataPointProvider);
    }

    @Override
    public String clusteringStats() {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        CentroidClusteringUtils.writeClusteringStatsToStream(this.getClusters(), this.measure, b);
        return b.toString();
    }

    @Override
    public void writeClusteringStatsToStream(OutputStream outf) {
        CentroidClusteringUtils.writeClusteringStatsToStream(this.getClusters(), this.measure, outf);
    }
}

