/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.ml.cluster.hierarchical;

import com.davidsoergel.dsutils.collections.Symmetric2dBiMap;
import edu.berkeley.compbio.ml.cluster.Clusterable;
import edu.berkeley.compbio.ml.cluster.hierarchical.Agglomerator;
import edu.berkeley.compbio.ml.cluster.hierarchical.HierarchicalCentroidCluster;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleLinkageAgglomerator<T extends Clusterable<T>>
extends Agglomerator<T> {
    private static final Logger logger = Logger.getLogger(SingleLinkageAgglomerator.class);

    @Override
    protected void addCompositeVsNodeToDistanceMatrix(HierarchicalCentroidCluster<T> origA, HierarchicalCentroidCluster<T> origB, HierarchicalCentroidCluster<T> composite, HierarchicalCentroidCluster<T> otherNode, Symmetric2dBiMap<HierarchicalCentroidCluster<T>, Float> theActiveNodeDistanceMatrix) {
        if (otherNode != origA && otherNode != origB && otherNode != composite) {
            Float aDist = theActiveNodeDistanceMatrix.get(origA, otherNode);
            Float bDist = theActiveNodeDistanceMatrix.get(origB, otherNode);
            float d = Math.min(aDist.floatValue(), bDist.floatValue());
            theActiveNodeDistanceMatrix.put(otherNode, composite, Float.valueOf(d));
        }
    }
}

