/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.ml.cluster.kohonen;

import edu.berkeley.compbio.ml.cluster.AdditiveClusterable;
import edu.berkeley.compbio.ml.cluster.ClusterMove;
import edu.berkeley.compbio.ml.cluster.NoGoodClusterException;
import edu.berkeley.compbio.ml.cluster.kohonen.KohonenSOM2D;
import edu.berkeley.compbio.ml.cluster.kohonen.KohonenSOM2DSearchStrategy;
import edu.berkeley.compbio.ml.cluster.kohonen.KohonenSOMCell;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoarseGridSearchStrategy<T extends AdditiveClusterable<T>>
extends KohonenSOM2DSearchStrategy<T> {
    private static final Logger logger = Logger.getLogger(CoarseGridSearchStrategy.class);
    private int gridSpacing;
    private Set<? extends KohonenSOMCell<T>> sparseGrid;

    @Override
    public ClusterMove<T, KohonenSOMCell<T>> bestClusterMove(T p) throws NoGoodClusterException {
        double d;
        ClusterMove result = new ClusterMove();
        String id = p.getId();
        result.oldCluster = this.som.getAssignment(id);
        if (logger.isTraceEnabled()) {
            logger.trace("Choosing best cluster for " + p + " (previous = " + result.oldCluster + ")");
        }
        for (KohonenSOMCell<T> c : this.sparseGrid) {
            d = this.measure.distanceFromTo(p, c.getCentroid());
            if (d < result.bestDistance) {
                result.secondBestDistance = result.bestDistance;
                result.bestDistance = d;
                result.bestCluster = c;
                continue;
            }
            if (!(d < result.secondBestDistance)) continue;
            result.secondBestDistance = d;
        }
        Iterator<KohonenSOM2D.WeightedCell> i = this.som.getWeightedMask(this.gridSpacing * 2).iterator((KohonenSOMCell)result.bestCluster);
        while (i.hasNext()) {
            KohonenSOMCell<T> c;
            c = i.next().theCell;
            d = this.measure.distanceFromTo(p, c.getCentroid());
            if (d < result.bestDistance) {
                result.secondBestDistance = result.bestDistance;
                result.bestDistance = d;
                result.bestCluster = c;
                continue;
            }
            if (!(d < result.secondBestDistance)) continue;
            result.secondBestDistance = d;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Chose " + result.bestCluster);
        }
        if (result.bestCluster == null) {
            throw new NoGoodClusterException("No cluster found for " + p + ": " + result);
        }
        return result;
    }

    @Override
    public void setSOM(KohonenSOM2D<T> som) {
        super.setSOM(som);
        this.setGridSpacing(4);
    }

    public void setGridSpacing(int gridSpacing) {
        this.gridSpacing = gridSpacing;
        this.sparseGrid = this.getSparseGridClusters();
    }

    public Set<? extends KohonenSOMCell<T>> getSparseGridClusters() {
        HashSet result = new HashSet();
        int width = this.som.cellsPerDimension[0];
        int height = this.som.cellsPerDimension[1];
        for (int x = 0; x < width; x += this.gridSpacing) {
            for (int y = 0; y < height; y += this.gridSpacing) {
                if (x == width || y == height) continue;
                result.add(this.som.clusterAt(x, y));
            }
        }
        return result;
    }
}

