/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.ml.cluster.kohonen;

import com.davidsoergel.dsutils.DSArrayUtils;
import com.davidsoergel.dsutils.GenericFactory;
import com.davidsoergel.dsutils.GenericFactoryException;
import com.davidsoergel.stats.DissimilarityMeasure;
import com.davidsoergel.stats.SimpleFunction;
import edu.berkeley.compbio.ml.cluster.AbstractUnsupervisedOnlineClusteringMethod;
import edu.berkeley.compbio.ml.cluster.AdditiveClusterable;
import edu.berkeley.compbio.ml.cluster.CentroidClusteringUtils;
import edu.berkeley.compbio.ml.cluster.ClusterMove;
import edu.berkeley.compbio.ml.cluster.ClusterableIterator;
import edu.berkeley.compbio.ml.cluster.NoGoodClusterException;
import edu.berkeley.compbio.ml.cluster.ProhibitionModel;
import edu.berkeley.compbio.ml.cluster.kohonen.KohonenSOM;
import edu.berkeley.compbio.ml.cluster.kohonen.KohonenSOMCell;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.lang.NotImplementedException;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KohonenSOMnD<T extends AdditiveClusterable<T>>
extends AbstractUnsupervisedOnlineClusteringMethod<T, KohonenSOMCell<T>>
implements KohonenSOM<T> {
    private static final Logger logger = Logger.getLogger(KohonenSOMnD.class);
    final int[] cellsPerDimension;
    final int[] blockSize;
    int time = 0;
    final KohonenSOMCell<T>[] immediateNeighbors;
    private final int dimensions;
    private final boolean edgesWrap;
    private final boolean decrementLosingNeighborhood;
    private final SimpleFunction moveFactorFunction;
    private final SimpleFunction radiusFunction;
    private int idCount = 0;
    private final double defaultMaxRadius;

    public KohonenSOMnD(DissimilarityMeasure<T> dm, Set<String> potentialTrainingBins, Map<String, Set<String>> predictLabelSets, ProhibitionModel<T> prohibitionModel, Set<String> testLabels, int[] cellsPerDimension, SimpleFunction moveFactorFunction, SimpleFunction radiusFunction, boolean decrementLosingNeighborhood, boolean edgesWrap) {
        super(dm, potentialTrainingBins, predictLabelSets, prohibitionModel, testLabels);
        this.cellsPerDimension = cellsPerDimension;
        this.dimensions = cellsPerDimension.length;
        this.moveFactorFunction = moveFactorFunction;
        this.radiusFunction = radiusFunction;
        this.decrementLosingNeighborhood = decrementLosingNeighborhood;
        this.edgesWrap = edgesWrap;
        this.immediateNeighbors = new KohonenSOMCell[2 * this.dimensions];
        this.blockSize = new int[this.dimensions];
        this.blockSize[this.dimensions - 1] = 1;
        for (int i = this.dimensions - 2; i > 0; --i) {
            this.blockSize[i] = this.blockSize[i + 1] * cellsPerDimension[i];
        }
        this.defaultMaxRadius = DSArrayUtils.norm(cellsPerDimension);
    }

    @Override
    public String shortClusteringStats() {
        return CentroidClusteringUtils.shortClusteringStats(this.getClusters(), this.measure);
    }

    @Override
    public void computeClusterStdDevs(ClusterableIterator<T> theDataPointProvider) {
        CentroidClusteringUtils.computeClusterStdDevs(this.getClusters(), this.measure, this.getAssignments(), theDataPointProvider);
    }

    @Override
    public String clusteringStats() {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        CentroidClusteringUtils.writeClusteringStatsToStream(this.getClusters(), this.measure, b);
        return b.toString();
    }

    @Override
    public void writeClusteringStatsToStream(OutputStream outf) {
        CentroidClusteringUtils.writeClusteringStatsToStream(this.getClusters(), this.measure, outf);
    }

    @Override
    public Iterator<Set<KohonenSOMCell<T>>> getNeighborhoodShellIterator(KohonenSOMCell<T> cell) {
        return new NeighborhoodShellIterator(cell, this.defaultMaxRadius);
    }

    @Override
    public boolean add(T p) throws NoGoodClusterException {
        AdditiveClusterable motion;
        KohonenSOMCell neighbor;
        NeighborhoodIterator i;
        ClusterMove<T, KohonenSOMCell<T>> cm = this.bestClusterMove((T)p);
        KohonenSOMCell loser = (KohonenSOMCell)cm.oldCluster;
        KohonenSOMCell winner = (KohonenSOMCell)cm.bestCluster;
        if (this.decrementLosingNeighborhood) {
            i = new NeighborhoodIterator(loser, this.time);
            while (i.hasNext()) {
                neighbor = (KohonenSOMCell)i.next();
                motion = p.minus((AdditiveClusterable)((AdditiveClusterable)neighbor.getCentroid()));
                motion.multiplyBy(-this.moveFactor(this.time));
                neighbor.add(motion);
            }
        }
        i = new NeighborhoodIterator(winner, this.time);
        while (i.hasNext()) {
            neighbor = (KohonenSOMCell)i.next();
            motion = p.minus((AdditiveClusterable)((AdditiveClusterable)neighbor.getCentroid()));
            motion.multiplyBy(this.moveFactor(this.time));
            neighbor.add(motion);
        }
        ++this.time;
        return true;
    }

    @Override
    public void setPrototypeFactory(GenericFactory<T> prototypeFactory) throws GenericFactoryException {
        int[] zeroCell = new int[this.dimensions];
        Arrays.fill(zeroCell, 0);
        this.createClusters(zeroCell, -1, prototypeFactory);
    }

    @Override
    public void initializeWithSamples(ClusterableIterator<T> initIterator, int initSamples) {
        for (int i = 0; i < initSamples; ++i) {
            this.addToRandomCell((AdditiveClusterable)initIterator.nextFullyLabelled());
            if (i % 100 != 0) continue;
            logger.debug("Initialized with " + i + " samples.");
        }
    }

    public void addToRandomCell(T p) {
        throw new NotImplementedException();
    }

    @Override
    public ClusterMove<T, KohonenSOMCell<T>> bestClusterMove(T p) {
        ClusterMove result = new ClusterMove();
        String id = p.getId();
        result.oldCluster = this.getAssignment(id);
        if (logger.isTraceEnabled()) {
            logger.trace("Choosing best cluster for " + p + " (previous = " + result.oldCluster + ")");
        }
        for (KohonenSOMCell c : this.getClusters()) {
            double d = this.measure.distanceFromTo(p, c.getCentroid());
            if (logger.isTraceEnabled()) {
                logger.trace("Trying " + c + "; distance = " + d + "; best so far = " + result.bestDistance);
            }
            if (d < result.bestDistance) {
                result.secondBestDistance = result.bestDistance;
                result.bestDistance = d;
                result.bestCluster = c;
                continue;
            }
            if (!(d < result.secondBestDistance)) continue;
            result.secondBestDistance = d;
        }
        if (logger.isDebugEnabled()) {
            logger.trace("Chose " + result.bestCluster);
        }
        if (result.bestCluster == null) {
            logger.warn("Can't classify: " + p);
            assert (false);
        }
        return result;
    }

    private int[] cellPositionFor(int listIndex) {
        int[] result = new int[this.dimensions];
        for (int i = 0; i < this.dimensions; ++i) {
            result[i] = listIndex / this.blockSize[i];
            listIndex %= this.blockSize[i];
        }
        return result;
    }

    private void createClusters(int[] cellPosition, int changingDimension, GenericFactory<T> prototypeFactory) throws GenericFactoryException {
        if (++changingDimension == this.dimensions) {
            KohonenSOMCell<AdditiveClusterable> c = new KohonenSOMCell<AdditiveClusterable>(this.idCount++, (AdditiveClusterable)prototypeFactory.create(new Object[0]));
            this.setCluster(this.listIndexFor(cellPosition), c);
        } else {
            int i = 0;
            while (i < this.cellsPerDimension[changingDimension]) {
                cellPosition[changingDimension] = i++;
                this.createClusters(cellPosition, changingDimension, prototypeFactory);
            }
        }
    }

    private int listIndexFor(int[] cellposition) {
        assert (cellposition.length == this.cellsPerDimension.length);
        int result = 0;
        for (int i = 0; i < this.dimensions; ++i) {
            result += cellposition[i] * this.blockSize[i];
        }
        return result;
    }

    private double moveFactor(int time) {
        return this.moveFactorFunction.f(time);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NeighborhoodIterator
    implements Iterator<KohonenSOMCell<T>> {
        private final NeighborhoodShellIterator shells;
        private Set<KohonenSOMCell<T>> currentShell;
        private Iterator<KohonenSOMCell<T>> currentShellIterator;
        private final double maxRadius;

        private NeighborhoodIterator(KohonenSOMCell<T> center, int time) {
            this.maxRadius = KohonenSOMnD.this.radiusFunction.f(time);
            this.shells = new NeighborhoodShellIterator(center, this.maxRadius);
        }

        @Override
        public boolean hasNext() {
            return this.currentShellIterator.hasNext() || this.shells.hasNext() && this.shells.getNextRadius() <= this.maxRadius;
        }

        @Override
        public KohonenSOMCell<T> next() {
            try {
                return this.currentShellIterator.next();
            }
            catch (NoSuchElementException e) {
                if (this.shells.getNextRadius() > this.maxRadius) {
                    throw new NoSuchElementException();
                }
                this.currentShell = this.shells.next();
                this.currentShellIterator = this.currentShell.iterator();
                return this.currentShellIterator.next();
            }
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NeighborhoodShellIterator
    implements Iterator<Set<KohonenSOMCell<T>>> {
        int radius = 0;
        final int[] centerPos;
        Set<KohonenSOMCell<T>> prevShell = new HashSet();
        Set<KohonenSOMCell<T>> prevPrevShell = new HashSet();
        private int radiusSquared;
        private final double maxRadius;

        public NeighborhoodShellIterator(KohonenSOMCell<T> cell, double maxRadius) {
            this.centerPos = KohonenSOMnD.this.cellPositionFor(KohonenSOMnD.this.getClusters().indexOf(cell));
            this.prevShell.add(cell);
            this.maxRadius = maxRadius;
        }

        @Override
        public boolean hasNext() {
            return (double)(this.radius + 1) <= this.maxRadius;
        }

        @Override
        public Set<KohonenSOMCell<T>> next() {
            HashSet shell = new HashSet();
            for (KohonenSOMCell cell : this.prevShell) {
                this.computeImmediateNeighbors(cell);
                for (KohonenSOMCell neighbor : KohonenSOMnD.this.immediateNeighbors) {
                    if (neighbor == null || this.prevShell.contains(neighbor) || this.prevPrevShell.contains(neighbor) || !this.isWithinCurrentRadius(neighbor)) continue;
                    shell.add(neighbor);
                }
            }
            this.prevPrevShell = this.prevShell;
            this.prevShell = shell;
            ++this.radius;
            this.radiusSquared = this.radius * this.radius;
            return shell;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        private void computeImmediateNeighbors(KohonenSOMCell<T> trav) {
            List clusterList = KohonenSOMnD.this.getClusters();
            int[] pos = KohonenSOMnD.this.cellPositionFor(clusterList.indexOf(trav));
            int i = 0;
            while (i < KohonenSOMnD.this.dimensions) {
                int n = i;
                pos[n] = pos[n] - 1;
                if (pos[i] == -1) {
                    if (KohonenSOMnD.this.edgesWrap) {
                        pos[i] = KohonenSOMnD.this.cellsPerDimension[i] - 1;
                        KohonenSOMnD.this.immediateNeighbors[2 * i] = (KohonenSOMCell)clusterList.get(KohonenSOMnD.this.listIndexFor(pos));
                        pos[i] = -1;
                    } else {
                        KohonenSOMnD.this.immediateNeighbors[2 * i] = null;
                    }
                } else {
                    KohonenSOMnD.this.immediateNeighbors[2 * i] = (KohonenSOMCell)clusterList.get(KohonenSOMnD.this.listIndexFor(pos));
                }
                int n2 = i;
                pos[n2] = pos[n2] + 2;
                if (pos[i] == KohonenSOMnD.this.cellsPerDimension[i] - 1) {
                    if (KohonenSOMnD.this.edgesWrap) {
                        pos[i] = 0;
                        KohonenSOMnD.this.immediateNeighbors[2 * i + 1] = (KohonenSOMCell)clusterList.get(KohonenSOMnD.this.listIndexFor(pos));
                        pos[i] = KohonenSOMnD.this.cellsPerDimension[i] - 1;
                    } else {
                        KohonenSOMnD.this.immediateNeighbors[2 * i + 1] = null;
                    }
                } else {
                    KohonenSOMnD.this.immediateNeighbors[2 * i + 1] = (KohonenSOMCell)clusterList.get(KohonenSOMnD.this.listIndexFor(pos));
                }
                int n3 = i++;
                pos[n3] = pos[n3] - 1;
            }
        }

        private double getNextRadius() {
            return this.radius + 1;
        }

        private boolean isWithinCurrentRadius(KohonenSOMCell<T> neighbor) {
            int[] pos = KohonenSOMnD.this.cellPositionFor(KohonenSOMnD.this.getClusters().indexOf(neighbor));
            int sum = 0;
            for (int i = 0; i < KohonenSOMnD.this.dimensions; ++i) {
                int dist = Math.abs(pos[i] - this.centerPos[i]);
                if (KohonenSOMnD.this.edgesWrap) {
                    dist = Math.min(dist, KohonenSOMnD.this.cellsPerDimension[i] - dist);
                }
                sum += dist * dist;
            }
            return sum <= this.radiusSquared;
        }
    }
}

