/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.ml.mcmc;

import com.davidsoergel.dsutils.GenericFactory;
import com.davidsoergel.runutils.PluginMap;
import com.davidsoergel.runutils.Property;
import com.davidsoergel.runutils.PropertyConsumer;
import com.davidsoergel.stats.DistributionException;
import com.davidsoergel.stats.Multinomial;
import edu.berkeley.compbio.ml.mcmc.MonteCarloState;
import edu.berkeley.compbio.ml.mcmc.Move;
import java.util.Collection;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PropertyConsumer
public class MoveTypeSet {
    private static final Logger logger = Logger.getLogger(MoveTypeSet.class);
    @Property(defaultvalue="edu.berkeley.compbio.ml.mcmc.Move {edu.berkeley.compbio.ml.mcmc.mcmcmc}")
    public PluginMap<Double> pluginMap;
    private final Multinomial<GenericFactory<Move>> types = new Multinomial();

    public Collection<GenericFactory<Move>> getFactories() {
        return this.types.getElements();
    }

    public void init() {
        try {
            for (Class movetype : this.pluginMap.getAvailablePlugins()) {
                String shortname = movetype.getName();
                shortname = shortname.substring(shortname.lastIndexOf(".") + 1);
                Double prob = this.pluginMap.getValue(movetype);
                if (prob == null || Double.isNaN(prob)) {
                    logger.warn("No move probability found for " + shortname + "; assigning probability zero.");
                    continue;
                }
                if (prob == 0.0) continue;
                this.types.put(this.pluginMap.getFactory(movetype), prob);
            }
            this.types.normalize();
        }
        catch (DistributionException e) {
            logger.error("Error", e);
            throw new Error(e);
        }
    }

    public Move newMove(MonteCarloState currentMonteCarloState) {
        try {
            GenericFactory<Move> c = this.types.sample();
            Object[] args = new Object[]{currentMonteCarloState};
            return c.create(args);
        }
        catch (Exception e) {
            logger.error("Error", e);
            throw new Error(e);
        }
    }
}

