/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.ml.mcmc.mcmcmc;

import com.davidsoergel.dsutils.DSStringUtils;
import com.davidsoergel.dsutils.GenericFactory;
import com.davidsoergel.dsutils.GenericFactoryException;
import com.davidsoergel.runutils.Property;
import com.davidsoergel.runutils.PropertyConsumer;
import edu.berkeley.compbio.ml.mcmc.MonteCarlo;
import edu.berkeley.compbio.ml.mcmc.MonteCarloState;
import edu.berkeley.compbio.ml.mcmc.mcmcmc.ChainList;
import java.io.IOException;
import org.apache.log4j.Logger;

@PropertyConsumer
public class MetropolisCoupledMonteCarlo
extends MonteCarlo {
    private static final Logger logger = Logger.getLogger(MetropolisCoupledMonteCarlo.class);
    @Property(helpmessage="", defaultvalue="edu.berkeley.compbio.ml.mcmc.MonteCarlo")
    public GenericFactory<MonteCarlo> chainFactory;
    @Property(helpmessage="heat factors for each subchain.", defaultvalue="1,2,4,8,16,32")
    public Double[] heatFactors;
    public ChainList currentState = new ChainList();

    public ChainList getCurrentState() {
        return this.currentState;
    }

    public void init() {
        super.init();
    }

    public void run() throws IOException, GenericFactoryException {
        int i;
        assert (this.heatFactors[0] == 1.0);
        ChainList chains = new ChainList();
        Double[] arr$ = this.heatFactors;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            double hf = arr$[i$];
            MonteCarlo subChain = this.chainFactory.create(new Object[0]);
            subChain.setHeatFactor(hf);
            subChain.setId(String.valueOf(hf));
            subChain.setDataCollector(this.dataCollector.newSubCollector(String.valueOf(hf)));
            subChain.setColdest(false);
            chains.add(subChain);
        }
        MonteCarlo mc = (MonteCarlo)chains.get(0);
        mc.setColdest(true);
        this.setCurrentChainList(chains);
        this.setColdest(true);
        this.setId("COUPLING");
        logger.debug("Initialized MCMCMC: " + DSStringUtils.join((Object[])this.heatFactors, ", "));
        for (i = 0; i < this.burnIn; ++i) {
            this.doBurnInStep();
        }
        for (i = 0; i < this.numSteps; ++i) {
            this.doStep();
        }
    }

    public void setCurrentChainList(ChainList currentChainList) {
        this.currentState = currentChainList;
    }

    public void doBurnInStep() throws IOException, GenericFactoryException {
        for (MonteCarlo chain : this.getCurrentChainList()) {
            chain.burnIn();
        }
        super.doStep();
        this.resetCounts();
    }

    public ChainList getCurrentChainList() {
        return this.currentState;
    }

    public void doStep() throws IOException, GenericFactoryException {
        for (MonteCarlo chain : this.getCurrentChainList()) {
            chain.runNoBurnIn();
        }
        super.doStep();
    }

    public void setCurrentState(MonteCarloState currentState) {
        this.currentState = (ChainList)currentState;
    }
}

