/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.compbio.ml.mcmc.mcmcmc;

import com.davidsoergel.dsutils.math.MersenneTwisterFast;
import edu.berkeley.compbio.ml.mcmc.MonteCarlo;
import edu.berkeley.compbio.ml.mcmc.Move;
import edu.berkeley.compbio.ml.mcmc.ProbabilityMove;
import edu.berkeley.compbio.ml.mcmc.mcmcmc.ChainList;
import org.apache.log4j.Logger;

public class MetropolisCoupledSwapMove
extends Move
implements ProbabilityMove {
    private static final Logger logger = Logger.getLogger(MetropolisCoupledSwapMove.class);
    private ChainList chains;
    private int swap1;
    private int swap2;

    public MetropolisCoupledSwapMove(ChainList cl) {
        this.chains = cl;
        this.propose();
    }

    public final void propose() {
        this.swap1 = MersenneTwisterFast.randomInt(this.chains.size() - 1);
        this.swap2 = this.swap1 + 1;
    }

    public ChainList doMove(double temperature) {
        if (this.isAccepted()) {
            MonteCarlo mc1 = (MonteCarlo)this.chains.get(this.swap1);
            MonteCarlo mc2 = (MonteCarlo)this.chains.get(this.swap2);
            logger.debug("SWAPPING CHAINS " + this.swap1 + " (" + mc1.getHeatFactor() + ") " + this.swap2 + " (" + mc2.getHeatFactor() + ") ");
            double temp = mc1.getHeatFactor();
            mc1.setHeatFactor(mc2.getHeatFactor());
            mc2.setHeatFactor(temp);
            if (mc1.isColdest()) {
                mc1.setColdest(false);
                mc2.setColdest(true);
            } else if (mc2.isColdest()) {
                mc2.setColdest(false);
                mc1.setColdest(true);
            }
            ChainList newChains = new ChainList();
            newChains.addAll(this.chains);
            this.chains = newChains;
        }
        return this.chains;
    }

    private boolean isAccepted() {
        MonteCarlo mc1 = (MonteCarlo)this.chains.get(this.swap1);
        MonteCarlo mc2 = (MonteCarlo)this.chains.get(this.swap2);
        double swapLogLikelihoodRatio = mc1.unnormalizedLogLikelihood(mc2.getCurrentState()) + mc2.unnormalizedLogLikelihood(mc1.getCurrentState()) - (mc1.unnormalizedLogLikelihood(mc1.getCurrentState()) + mc2.unnormalizedLogLikelihood(mc2.getCurrentState()));
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Swap log likelihood components: (%f * %f) / (%f * %f)", mc1.unnormalizedLogLikelihood(mc2.getCurrentState()), mc2.unnormalizedLogLikelihood(mc1.getCurrentState()), mc1.unnormalizedLogLikelihood(mc1.getCurrentState()), mc2.unnormalizedLogLikelihood(mc2.getCurrentState())));
            logger.debug("swapLogLikelihoodRatio = " + swapLogLikelihoodRatio);
        }
        return Math.log(MersenneTwisterFast.random()) < swapLogLikelihoodRatio;
    }
}

